/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Collections;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.DefaultQueueBrowseStrategy;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed JMS Queue Endpoint")
public class JmsQueueEndpoint
extends JmsEndpoint
implements BrowsableEndpoint {
    private int maximumBrowseSize = -1;
    private final QueueBrowseStrategy queueBrowseStrategy;

    public JmsQueueEndpoint(Queue destination) throws JMSException {
        this("jms:queue:" + destination.getQueueName(), null);
        this.setDestination((Destination)destination);
    }

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        this(uri, component, destination, configuration, null);
    }

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        super(uri, component, destination, false, configuration);
        this.queueBrowseStrategy = queueBrowseStrategy == null ? this.createQueueBrowseStrategy() : queueBrowseStrategy;
    }

    public JmsQueueEndpoint(String endpointUri, String destination, QueueBrowseStrategy queueBrowseStrategy) {
        super(endpointUri, destination, false);
        this.queueBrowseStrategy = queueBrowseStrategy == null ? this.createQueueBrowseStrategy() : queueBrowseStrategy;
    }

    public JmsQueueEndpoint(String endpointUri, String destination) {
        super(endpointUri, destination, false);
        this.queueBrowseStrategy = this.createQueueBrowseStrategy();
    }

    @ManagedAttribute
    public int getMaximumBrowseSize() {
        return this.maximumBrowseSize;
    }

    @ManagedAttribute
    public void setMaximumBrowseSize(int maximumBrowseSize) {
        this.maximumBrowseSize = maximumBrowseSize;
    }

    public List<Exchange> getExchanges() {
        if (this.queueBrowseStrategy == null) {
            return Collections.emptyList();
        }
        String queue = this.getDestinationName();
        JmsOperations template = this.getConfiguration().createInOnlyTemplate(this, false, queue);
        return this.queueBrowseStrategy.browse(template, queue, this);
    }

    @ManagedOperation(description="Current number of Exchanges in Queue")
    public long qeueSize() {
        return this.getExchanges().size();
    }

    @ManagedOperation(description="Get Exchange from queue by index")
    public String browseExchange(Integer index) {
        Exchange exchange = this.getExchanges().get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.toString();
    }

    protected QueueBrowseStrategy createQueueBrowseStrategy() {
        return new DefaultQueueBrowseStrategy();
    }
}

