/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.math.BigInteger;
import java.util.Random;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.reply.MessageSelectorCreator;
import org.apache.camel.component.jms.reply.PersistentQueueReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.UnknownReplyMessageException;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class PersistentQueueReplyManager
extends ReplyManagerSupport {
    private String replyToSelectorValue;
    private MessageSelectorCreator dynamicMessageSelector;

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        PersistentQueueReplyHandler handler = new PersistentQueueReplyHandler(replyManager, exchange, callback, originalCorrelationId, requestTimeout, this.dynamicMessageSelector);
        this.correlation.put(correlationId, handler, requestTimeout);
        if (this.dynamicMessageSelector != null) {
            this.dynamicMessageSelector.addCorrelationID(correlationId);
        }
        return correlationId;
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        ReplyHandler handler;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Updated provisional correlationId [" + correlationId + "] to expected correlationId [" + newCorrelationId + "]");
        }
        if ((handler = (ReplyHandler)this.correlation.remove(correlationId)) == null) {
            return;
        }
        this.correlation.put(newCorrelationId, handler, requestTimeout);
        if (this.dynamicMessageSelector != null) {
            this.dynamicMessageSelector.removeCorrelationID(correlationId);
            this.dynamicMessageSelector.addCorrelationID(newCorrelationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            try {
                handler.onReply(correlationID, message);
            }
            finally {
                if (this.dynamicMessageSelector != null) {
                    this.dynamicMessageSelector.removeCorrelationID(correlationID);
                }
                this.correlation.remove(correlationID);
            }
        } else {
            String text = "Reply received for unknown correlationID [" + correlationID + "] -> " + message;
            this.log.warn(text);
            throw new UnknownReplyMessageException(text, message, correlationID);
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
        String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
        if (replyToSelectorName != null && this.replyToSelectorValue != null) {
            camelMessage.setHeader(replyToSelectorName, (Object)this.replyToSelectorValue);
            jmsMessage.setStringProperty(replyToSelectorName, this.replyToSelectorValue);
        }
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        PersistentQueueMessageListenerContainer answer;
        String replyToSelectorName = this.endpoint.getReplyToDestinationSelectorName();
        if (replyToSelectorName != null) {
            this.replyToSelectorValue = "ID:" + new BigInteger(192, new Random()).toString(16);
            String fixedMessageSelector = replyToSelectorName + "='" + this.replyToSelectorValue + "'";
            answer = new PersistentQueueMessageListenerContainer(fixedMessageSelector);
        } else {
            this.dynamicMessageSelector = new MessageSelectorCreator();
            answer = new PersistentQueueMessageListenerContainer(this.dynamicMessageSelector);
        }
        DestinationResolver resolver = this.endpoint.getDestinationResolver();
        if (resolver == null) {
            resolver = answer.getDestinationResolver();
        }
        answer.setDestinationResolver(new DestinationResolverDelegate(resolver));
        answer.setDestinationName(this.endpoint.getReplyTo());
        answer.setAutoStartup(true);
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(1);
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        answer.setCacheLevel(2);
        answer.setSessionTransacted(false);
        if (this.endpoint.getExceptionListener() != null) {
            answer.setExceptionListener(this.endpoint.getExceptionListener());
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        return answer;
    }

    private final class PersistentQueueMessageListenerContainer
    extends DefaultMessageListenerContainer {
        private String fixedMessageSelector;
        private MessageSelectorCreator creator;

        private PersistentQueueMessageListenerContainer(String fixedMessageSelector) {
            this.fixedMessageSelector = fixedMessageSelector;
        }

        private PersistentQueueMessageListenerContainer(MessageSelectorCreator creator) {
            this.creator = creator;
        }

        public String getMessageSelector() {
            String id = null;
            if (this.fixedMessageSelector != null) {
                id = this.fixedMessageSelector;
            } else if (this.creator != null) {
                id = this.creator.get();
            }
            if (PersistentQueueReplyManager.this.log.isTraceEnabled()) {
                PersistentQueueReplyManager.this.log.trace("Using MessageSelector[" + id + "]");
            }
            return id;
        }
    }

    private final class DestinationResolverDelegate
    implements DestinationResolver {
        private DestinationResolver delegate;
        private Destination destination;

        public DestinationResolverDelegate(DestinationResolver delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
            PersistentQueueReplyManager persistentQueueReplyManager = PersistentQueueReplyManager.this;
            synchronized (persistentQueueReplyManager) {
                if (this.destination == null) {
                    this.destination = this.delegate.resolveDestinationName(session, destinationName, pubSubDomain);
                    PersistentQueueReplyManager.this.setReplyTo(this.destination);
                }
            }
            return this.destination;
        }
    }
}

