/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyHandler;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.ErrorHandler;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    public TemporaryQueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        TemporaryQueueReplyHandler handler = new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
        this.correlation.put(correlationId, handler, requestTimeout);
        return correlationId;
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = this.correlation.remove(correlationId);
        if (handler != null) {
            this.correlation.put(newCorrelationId, handler, requestTimeout);
        }
    }

    @Override
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            this.correlation.remove(correlationID);
            handler.onReply(correlationID, message);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        DefaultMessageListenerContainer answer = new DefaultMessageListenerContainer();
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(new DestinationResolver(){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                TemporaryQueue queue = session.createTemporaryQueue();
                TemporaryQueueReplyManager.this.setReplyTo((Destination)queue);
                return queue;
            }
        });
        answer.setAutoStartup(true);
        answer.setMessageListener((Object)this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(1);
        answer.setMaxConcurrentConsumers(1);
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        answer.setSessionTransacted(false);
        if (this.endpoint.getExceptionListener() != null) {
            answer.setExceptionListener(this.endpoint.getExceptionListener());
        }
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler((ErrorHandler)new DefaultSpringErrorHandler(TemporaryQueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        String name = "TemporaryQueueReplyManager[" + answer.getDestinationName() + "]";
        name = this.endpoint.getCamelContext().getExecutorServiceManager().resolveThreadName(name);
        answer.setBeanName(name);
        return answer;
    }
}

