/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jolt;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.Defaultr;
import com.bazaarvoice.jolt.JsonUtils;
import com.bazaarvoice.jolt.Removr;
import com.bazaarvoice.jolt.Shiftr;
import com.bazaarvoice.jolt.Sortr;
import com.bazaarvoice.jolt.Transform;
import java.io.InputStream;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jolt.JoltComponent;
import org.apache.camel.component.jolt.JoltInputOutputType;
import org.apache.camel.component.jolt.JoltTransformType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.16.0", scheme="jolt", title="JOLT", syntax="jolt:resourceUri", producerOnly=true, label="transformation")
public class JoltEndpoint
extends ResourceEndpoint {
    private Transform transform;
    @UriParam(defaultValue="Hydrated")
    private JoltInputOutputType outputType;
    @UriParam(defaultValue="Hydrated")
    private JoltInputOutputType inputType;
    @UriParam(defaultValue="Chainr")
    private JoltTransformType transformDsl = JoltTransformType.Chainr;

    public JoltEndpoint() {
    }

    public JoltEndpoint(String uri, JoltComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "jolt:" + this.getResourceUri();
    }

    private synchronized Transform getTransform() throws Exception {
        if (this.transform == null) {
            if (this.log.isDebugEnabled()) {
                String path = this.getResourceUri();
                this.log.debug("Jolt content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            }
            if (this.transformDsl == JoltTransformType.Sortr) {
                this.transform = new Sortr();
            } else {
                Object spec = JsonUtils.jsonToObject((InputStream)this.getResourceAsInputStream());
                switch (this.transformDsl) {
                    case Shiftr: {
                        this.transform = new Shiftr(spec);
                        break;
                    }
                    case Defaultr: {
                        this.transform = new Defaultr(spec);
                        break;
                    }
                    case Removr: {
                        this.transform = new Removr(spec);
                        break;
                    }
                    default: {
                        this.transform = Chainr.fromSpec((Object)spec);
                    }
                }
            }
        }
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public JoltInputOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(JoltInputOutputType outputType) {
        this.outputType = outputType;
    }

    public JoltInputOutputType getInputType() {
        return this.inputType;
    }

    public void setInputType(JoltInputOutputType inputType) {
        this.inputType = inputType;
    }

    public JoltTransformType getTransformDsl() {
        return this.transformDsl;
    }

    public void setTransformDsl(JoltTransformType transformType) {
        this.transformDsl = transformType;
    }

    public JoltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (JoltEndpoint)this.getCamelContext().getEndpoint(newUri, JoltEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelJoltResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelJoltResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelJoltResourceUri", (Object)newResourceUri);
            JoltEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        Object input = this.getInputType() == JoltInputOutputType.JsonString ? JsonUtils.jsonToObject((InputStream)((InputStream)exchange.getIn().getBody(InputStream.class))) : exchange.getIn().getBody();
        Object output = this.getTransform().transform(input);
        Message out = exchange.getOut();
        if (this.getOutputType() == JoltInputOutputType.JsonString) {
            out.setBody((Object)JsonUtils.toJsonString((Object)output));
        } else {
            out.setBody(output);
        }
        out.setHeaders(exchange.getIn().getHeaders());
        out.setAttachments(exchange.getIn().getAttachments());
    }
}

