/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jolt;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.ContextualTransform;
import com.bazaarvoice.jolt.Defaultr;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtils;
import com.bazaarvoice.jolt.Removr;
import com.bazaarvoice.jolt.Shiftr;
import com.bazaarvoice.jolt.Sortr;
import com.bazaarvoice.jolt.Transform;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jolt.JoltComponent;
import org.apache.camel.component.jolt.JoltConstants;
import org.apache.camel.component.jolt.JoltInputOutputType;
import org.apache.camel.component.jolt.JoltTransformType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.16.0", scheme="jolt", title="JOLT", syntax="jolt:resourceUri", producerOnly=true, category={Category.TRANSFORMATION}, headersClass=JoltConstants.class)
public class JoltEndpoint
extends ResourceEndpoint {
    private JoltTransform transform;
    @UriParam(defaultValue="Hydrated")
    private JoltInputOutputType outputType;
    @UriParam(defaultValue="Hydrated")
    private JoltInputOutputType inputType;
    @UriParam(defaultValue="Chainr")
    private JoltTransformType transformDsl = JoltTransformType.Chainr;
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;

    public JoltEndpoint() {
    }

    public JoltEndpoint(String uri, JoltComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "jolt:" + this.getResourceUri();
    }

    private synchronized JoltTransform getTransform() throws Exception {
        if (this.transform == null) {
            if (this.log.isDebugEnabled()) {
                String path = this.getResourceUri();
                this.log.debug("Jolt content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            }
            if (this.transformDsl == JoltTransformType.Sortr) {
                this.transform = new Sortr();
            } else {
                Object spec = JsonUtils.jsonToObject((InputStream)this.getResourceAsInputStream());
                switch (this.transformDsl) {
                    case Shiftr: {
                        this.transform = new Shiftr(spec);
                        break;
                    }
                    case Defaultr: {
                        this.transform = new Defaultr(spec);
                        break;
                    }
                    case Removr: {
                        this.transform = new Removr(spec);
                        break;
                    }
                    default: {
                        this.transform = Chainr.fromSpec((Object)spec);
                    }
                }
            }
        }
        return this.transform;
    }

    public void setTransform(JoltTransform transform) {
        this.transform = transform;
    }

    public JoltInputOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(JoltInputOutputType outputType) {
        this.outputType = outputType;
    }

    public JoltInputOutputType getInputType() {
        return this.inputType;
    }

    public void setInputType(JoltInputOutputType inputType) {
        this.inputType = inputType;
    }

    public JoltTransformType getTransformDsl() {
        return this.transformDsl;
    }

    public void setTransformDsl(JoltTransformType transformType) {
        this.transformDsl = transformType;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public JoltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (JoltEndpoint)this.getCamelContext().getEndpoint(newUri, JoltEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = null;
        if (this.allowTemplateFromHeader) {
            newResourceUri = (String)exchange.getIn().getHeader("CamelJoltResourceUri", String.class);
        }
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelJoltResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelJoltResourceUri", (Object)newResourceUri);
            JoltEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        Object input = this.getInputType() == JoltInputOutputType.JsonString ? JsonUtils.jsonToObject((InputStream)((InputStream)exchange.getIn().getBody(InputStream.class))) : exchange.getIn().getBody();
        Map inputContextMap = null;
        if (this.allowTemplateFromHeader) {
            inputContextMap = (Map)exchange.getIn().getHeader("CamelJoltContext", Map.class);
        }
        Object output = inputContextMap != null ? ((ContextualTransform)this.getTransform()).transform(input, inputContextMap) : ((Transform)this.getTransform()).transform(input);
        Message message = exchange.getMessage();
        if (this.getOutputType() == JoltInputOutputType.JsonString) {
            message.setBody((Object)JsonUtils.toJsonString((Object)output));
        } else {
            message.setBody(output);
        }
        message.setHeaders(exchange.getIn().getHeaders());
    }
}

