/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.jooq.JooqComponent;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqConsumer;
import org.apache.camel.component.jooq.JooqOperation;
import org.apache.camel.component.jooq.JooqProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.jooq.Query;
import org.jooq.ResultQuery;

@UriEndpoint(firstVersion="3.0.0", scheme="jooq", syntax="jooq://entityType/operation", title="JOOQ", label="jooq")
public class JooqEndpoint
extends ScheduledPollEndpoint {
    private Expression producerExpression;
    @UriParam
    private JooqConfiguration configuration;

    public JooqEndpoint(String uri, String remaining, JooqComponent component, JooqConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.initConfiguration(remaining);
    }

    private void initConfiguration(String remaining) {
        if (remaining == null) {
            return;
        }
        String[] parts = remaining.split("/");
        if (parts.length == 0 || parts.length > 2) {
            throw new IllegalArgumentException("Unexpected URI format. Expected ... , found '" + remaining + "'");
        }
        Class type = ObjectHelper.loadClass((String)parts[0]);
        if (type != null) {
            this.configuration.setEntityType(type);
        }
        if (parts.length > 1) {
            JooqOperation operation = JooqOperation.getByValue(parts[1]);
            if (operation != null) {
                this.configuration.setOperation(operation);
            } else {
                throw new IllegalArgumentException("Wrong operation: " + parts[1]);
            }
        }
    }

    public Producer createProducer() {
        return new JooqProducer(this, this.getProducerExpression());
    }

    public JooqConfiguration getConfiguration() {
        return this.configuration;
    }

    public Expression getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    protected Expression createProducerExpression() {
        Class type;
        switch (this.configuration.getOperation()) {
            case NONE: {
                type = this.configuration.getEntityType();
                break;
            }
            case EXECUTE: {
                type = Query.class;
                break;
            }
            case FETCH: {
                type = ResultQuery.class;
                break;
            }
            default: {
                type = null;
            }
        }
        if (type == null) {
            return ExpressionBuilder.bodyExpression();
        }
        return new Expression(){

            public Object evaluate(Exchange exchange, Class asType) {
                Object answer = exchange.getIn().getBody(type);
                if (answer == null) {
                    Object defaultValue = exchange.getIn().getBody();
                    if (defaultValue != null) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)new NoTypeConversionAvailableException(defaultValue, type));
                    }
                    answer = exchange.getContext().getInjector().newInstance(type);
                }
                return answer;
            }
        };
    }

    public Consumer createConsumer(Processor processor) {
        return new JooqConsumer(this, processor);
    }

    public boolean isSingleton() {
        return false;
    }

    public void setConfiguration(JooqConfiguration configuration) {
        this.configuration = configuration;
    }
}

