/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqEndpoint;
import org.apache.camel.component.jooq.JooqOperation;
import org.apache.camel.support.DefaultProducer;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Query;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public class JooqProducer
extends DefaultProducer {
    private final Expression expression;
    private JooqEndpoint endpoint;

    public JooqProducer(JooqEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.expression = expression;
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        JooqConfiguration configuration = this.endpoint.getConfiguration();
        Configuration dbConfig = configuration.getDatabaseConfiguration();
        JooqOperation operation = configuration.getOperation();
        switch (operation) {
            case EXECUTE: {
                Query query = (Query)this.expression.evaluate(exchange, Query.class);
                query.attach(dbConfig);
                query.execute();
                break;
            }
            case FETCH: {
                ResultQuery resultQuery = (ResultQuery)this.expression.evaluate(exchange, ResultQuery.class);
                resultQuery.attach(dbConfig);
                Result result = resultQuery.fetch();
                Message target = exchange.getPattern().isOutCapable() ? exchange.getOut() : exchange.getIn();
                target.setBody((Object)result);
                break;
            }
            case NONE: {
                UpdatableRecord entity = (UpdatableRecord)this.expression.evaluate(exchange, UpdatableRecord.class);
                DSLContext context = DSL.using((Configuration)dbConfig);
                context.batchStore(new UpdatableRecord[]{entity}).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong operation: " + operation.getValue());
            }
        }
    }
}

