/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqEndpoint;
import org.apache.camel.component.jooq.JooqOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="jooq")
public class JooqComponent
extends DefaultComponent {
    @Metadata(description="Component configuration (database connection, database entity type, etc.)")
    private JooqConfiguration configuration;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JooqConfiguration conf = this.configuration != null ? this.configuration.copy() : new JooqConfiguration();
        JooqEndpoint endpoint = new JooqEndpoint(uri, remaining, this, conf);
        this.setProperties((Endpoint)endpoint, parameters);
        JooqComponent.initConfiguration(this.getCamelContext(), conf, remaining);
        return endpoint;
    }

    public JooqConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JooqConfiguration jooqConfiguration) {
        this.configuration = jooqConfiguration;
    }

    private static void initConfiguration(CamelContext camelContext, JooqConfiguration configuration, String remaining) {
        if (remaining == null) {
            return;
        }
        String[] parts = remaining.split("/");
        if (parts.length == 0 || parts.length > 2) {
            throw new IllegalArgumentException("Unexpected URI format. Expected ... , found '" + remaining + "'");
        }
        String className = parts[0];
        Class type = camelContext.getClassResolver().resolveClass(className);
        if (type != null) {
            configuration.setEntityType(type);
        }
        if (parts.length > 1) {
            String op = parts[1];
            JooqOperation operation = (JooqOperation)((Object)camelContext.getTypeConverter().convertTo(JooqOperation.class, (Object)op));
            if (operation != null) {
                configuration.setOperation(operation);
            } else {
                throw new IllegalArgumentException("Wrong operation: " + op);
            }
        }
    }
}

