/*
 * This file is generated by jOOQ.
 */
package org.apache.camel.component.jooq.db.tables;


import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

import org.apache.camel.component.jooq.db.Keys;
import org.apache.camel.component.jooq.db.Public;
import org.apache.camel.component.jooq.db.tables.records.BookRecord;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row11;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;


/**
 * This class is generated by jOOQ.
 */
@SuppressWarnings({ "all", "unchecked", "rawtypes" })
public class Book extends TableImpl<BookRecord> {

    private static final long serialVersionUID = 1L;

    /**
     * The reference instance of <code>PUBLIC.BOOK</code>
     */
    public static final Book BOOK = new Book();

    /**
     * The class holding records for this type
     */
    @Override
    public Class<BookRecord> getRecordType() {
        return BookRecord.class;
    }

    /**
     * The column <code>PUBLIC.BOOK.ID</code>.
     */
    public final TableField<BookRecord, Integer> ID = createField(DSL.name("ID"), SQLDataType.INTEGER.nullable(false), this, "");

    /**
     * The column <code>PUBLIC.BOOK.AUTHOR_ID</code>.
     */
    public final TableField<BookRecord, Integer> AUTHOR_ID = createField(DSL.name("AUTHOR_ID"), SQLDataType.INTEGER.nullable(false), this, "");

    /**
     * The column <code>PUBLIC.BOOK.CO_AUTHOR_ID</code>.
     */
    public final TableField<BookRecord, Integer> CO_AUTHOR_ID = createField(DSL.name("CO_AUTHOR_ID"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.DETAILS_ID</code>.
     */
    public final TableField<BookRecord, Integer> DETAILS_ID = createField(DSL.name("DETAILS_ID"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.TITLE</code>.
     */
    public final TableField<BookRecord, String> TITLE = createField(DSL.name("TITLE"), SQLDataType.VARCHAR(400).nullable(false), this, "");

    /**
     * The column <code>PUBLIC.BOOK.PUBLISHED_IN</code>.
     */
    public final TableField<BookRecord, Integer> PUBLISHED_IN = createField(DSL.name("PUBLISHED_IN"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.LANGUAGE_ID</code>.
     */
    public final TableField<BookRecord, Integer> LANGUAGE_ID = createField(DSL.name("LANGUAGE_ID"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.CONTENT_TEXT</code>.
     */
    public final TableField<BookRecord, String> CONTENT_TEXT = createField(DSL.name("CONTENT_TEXT"), SQLDataType.CLOB, this, "");

    /**
     * The column <code>PUBLIC.BOOK.CONTENT_PDF</code>.
     */
    public final TableField<BookRecord, byte[]> CONTENT_PDF = createField(DSL.name("CONTENT_PDF"), SQLDataType.BLOB, this, "");

    /**
     * The column <code>PUBLIC.BOOK.REC_VERSION</code>.
     */
    public final TableField<BookRecord, Integer> REC_VERSION = createField(DSL.name("REC_VERSION"), SQLDataType.INTEGER, this, "");

    /**
     * The column <code>PUBLIC.BOOK.REC_TIMESTAMP</code>.
     */
    public final TableField<BookRecord, LocalDateTime> REC_TIMESTAMP = createField(DSL.name("REC_TIMESTAMP"), SQLDataType.LOCALDATETIME(6), this, "");

    private Book(Name alias, Table<BookRecord> aliased) {
        this(alias, aliased, null);
    }

    private Book(Name alias, Table<BookRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment(""), TableOptions.table());
    }

    /**
     * Create an aliased <code>PUBLIC.BOOK</code> table reference
     */
    public Book(String alias) {
        this(DSL.name(alias), BOOK);
    }

    /**
     * Create an aliased <code>PUBLIC.BOOK</code> table reference
     */
    public Book(Name alias) {
        this(alias, BOOK);
    }

    /**
     * Create a <code>PUBLIC.BOOK</code> table reference
     */
    public Book() {
        this(DSL.name("BOOK"), null);
    }

    public <O extends Record> Book(Table<O> child, ForeignKey<O, BookRecord> key) {
        super(child, key, BOOK);
    }

    @Override
    public Schema getSchema() {
        return Public.PUBLIC;
    }

    @Override
    public UniqueKey<BookRecord> getPrimaryKey() {
        return Keys.PK_T_BOOK;
    }

    @Override
    public List<UniqueKey<BookRecord>> getKeys() {
        return Arrays.<UniqueKey<BookRecord>>asList(Keys.PK_T_BOOK);
    }

    @Override
    public List<ForeignKey<BookRecord, ?>> getReferences() {
        return Arrays.<ForeignKey<BookRecord, ?>>asList(Keys.FK_T_BOOK_AUTHOR_ID, Keys.FK_T_BOOK_CO_AUTHOR_ID);
    }

    public Author fkTBookAuthorId() {
        return new Author(this, Keys.FK_T_BOOK_AUTHOR_ID);
    }

    public Author fkTBookCoAuthorId() {
        return new Author(this, Keys.FK_T_BOOK_CO_AUTHOR_ID);
    }

    @Override
    public Book as(String alias) {
        return new Book(DSL.name(alias), this);
    }

    @Override
    public Book as(Name alias) {
        return new Book(alias, this);
    }

    /**
     * Rename this table
     */
    @Override
    public Book rename(String name) {
        return new Book(DSL.name(name), null);
    }

    /**
     * Rename this table
     */
    @Override
    public Book rename(Name name) {
        return new Book(name, null);
    }

    // -------------------------------------------------------------------------
    // Row11 type methods
    // -------------------------------------------------------------------------

    @Override
    public Row11<Integer, Integer, Integer, Integer, String, Integer, Integer, String, byte[], Integer, LocalDateTime> fieldsRow() {
        return (Row11) super.fieldsRow();
    }
}
