/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqEndpoint;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public class JooqConsumer
extends ScheduledBatchPollingConsumer {
    public JooqConsumer(JooqEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public JooqEndpoint getEndpoint() {
        return (JooqEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        JooqConfiguration configuration = this.getEndpoint().getConfiguration();
        Configuration dbConfig = configuration.getDatabaseConfiguration();
        Class<?> entityType = configuration.getEntityType();
        DSLContext context = DSL.using((Configuration)dbConfig);
        LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
        Result results = context.selectFrom((TableLike)this.getTable(entityType)).fetch();
        this.forceConsumerAsReady();
        for (UpdatableRecord result : results) {
            DataHolder holder = new DataHolder();
            holder.exchange = this.createExchange(result);
            answer.add(holder);
        }
        int messagePolled = this.processBatch(CastUtils.cast(answer));
        if (configuration.isConsumeDelete()) {
            context.batchDelete((Collection)results).execute();
        }
        return messagePolled;
    }

    protected Exchange createExchange(Object result) {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setBody(result);
        return exchange;
    }

    private Table getTable(Class<?> entityType) {
        UpdatableRecord object = (UpdatableRecord)org.apache.camel.support.ObjectHelper.newInstance(entityType);
        return object.getTable();
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.isBatchAllowed()) {
            for (int i = 0; i < total; ++i) {
                DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
                this.getProcessor().process(holder.exchange);
            }
        }
        return total;
    }

    private static final class DataHolder {
        private Exchange exchange;

        private DataHolder() {
        }
    }
}

