/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.StaticService;
import org.apache.camel.language.joor.JoorCompilationException;
import org.apache.camel.language.joor.JoorMethod;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.joor.Reflect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoorCompiler
extends ServiceSupport
implements StaticService {
    private static final Pattern BEAN_INJECTION_PATTERN = Pattern.compile("(#bean:)([A-Za-z0-9-_]*)");
    private static final Pattern BODY_AS_PATTERN = Pattern.compile("(optionalBodyAs|bodyAs)\\(([A-Za-z0-9.$]*)(.class)\\)");
    private static final Pattern BODY_AS_PATTERN_NO_CLASS = Pattern.compile("(optionalBodyAs|bodyAs)\\(([A-Za-z0-9.$]*)\\)");
    private static final Pattern HEADER_AS_PATTERN = Pattern.compile("(optionalHeaderAs|headerAs)\\((['|\"][A-Za-z0-9.$]*['|\"]\\s*),\\s*([A-Za-z0-9.$]*.class)\\)");
    private static final Pattern HEADER_AS_PATTERN_NO_CLASS = Pattern.compile("(optionalHeaderAs|headerAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,\\s*([A-Za-z0-9.$]*)\\)");
    private static final Pattern HEADER_AS_DEFAULT_VALUE_PATTERN = Pattern.compile("(headerAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,(.+),\\s*([A-Za-z0-9.$]*.class)\\)");
    private static final Pattern HEADER_AS_DEFAULT_VALUE_PATTERN_NO_CLASS = Pattern.compile("(headerAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,(.+),\\s*([A-Za-z0-9.$]*)\\)");
    private static final Pattern EXCHANGE_PROPERTY_AS_PATTERN = Pattern.compile("(optionalExchangePropertyAs|exchangePropertyAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,\\s*([A-Za-z0-9.$]*.class)\\)");
    private static final Pattern EXCHANGE_PROPERTY_AS_PATTERN_NO_CLASS = Pattern.compile("(optionalExchangePropertyAs|exchangePropertyAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,\\s*([A-Za-z0-9.$]*)\\)");
    private static final Pattern EXCHANGE_PROPERTY_AS_DEFAULT_VALUE_PATTERN = Pattern.compile("(exchangePropertyAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,(.+),\\s*([A-Za-z0-9.$]*.class)\\)");
    private static final Pattern EXCHANGE_PROPERTY_AS_DEFAULT_VALUE_PATTERN_NO_CLASS = Pattern.compile("(exchangePropertyAs)\\((['|\"][A-Za-z0-9.$]*['|\"])\\s*,(.+),\\s*([A-Za-z0-9.$]*)\\)");
    private static final Logger LOG = LoggerFactory.getLogger(JoorCompiler.class);
    private static final AtomicInteger UUID = new AtomicInteger();
    private Set<String> imports = new TreeSet<String>();
    private Map<String, String> aliases;
    private int counter;
    private long taken;

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.counter > 0) {
            LOG.info("jOOR language compiled {} {} in {}", new Object[]{this.counter, this.counter == 1 ? "script" : "scripts", TimeUtils.printDuration((long)this.taken, (boolean)true)});
        }
    }

    public JoorMethod compile(CamelContext camelContext, String script, boolean singleQuotes) {
        JoorMethod answer;
        StopWatch watch = new StopWatch();
        String className = JoorCompiler.nextFQN();
        String code = this.evalCode(camelContext, className, script, singleQuotes);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compiling code:\n\n{}\n", (Object)code);
            }
            Reflect ref = Reflect.compile((String)className, (String)code);
            Class clazz = ref.type();
            answer = (JoorMethod)clazz.getConstructor(CamelContext.class).newInstance(camelContext);
        }
        catch (Exception e) {
            throw new JoorCompilationException(className, code, e);
        }
        ++this.counter;
        this.taken += watch.taken();
        return answer;
    }

    public String evalCode(CamelContext camelContext, String fqn, String script, boolean singleQuotes) {
        String qn = fqn.substring(0, fqn.lastIndexOf(46));
        String name = fqn.substring(fqn.lastIndexOf(46) + 1);
        script = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (String)script);
        script = script.trim();
        boolean biFunction = script.startsWith("(e1, e2) ->");
        script = this.staticHelper(script);
        script = this.alias(script);
        LinkedHashSet<String> scriptImports = new LinkedHashSet<String>();
        HashMap<String, Class> scriptBeans = new HashMap<String, Class>();
        script = this.evalDependencyInjection(camelContext, scriptImports, scriptBeans, script);
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(qn).append(";\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.util.concurrent.*;\n");
        sb.append("import java.util.function.*;\n");
        sb.append("import java.util.stream.*;\n");
        sb.append("\n");
        sb.append("import org.apache.camel.*;\n");
        sb.append("import org.apache.camel.util.*;\n");
        sb.append("import static org.apache.camel.language.joor.JoorHelper.*;\n");
        sb.append("\n");
        for (String string : this.imports) {
            sb.append(string);
            if (!string.endsWith(";")) {
                sb.append(";");
            }
            sb.append("\n");
        }
        for (String string : scriptImports) {
            sb.append("import ");
            sb.append(string);
            sb.append(";\n");
        }
        sb.append("\n");
        sb.append("public class ").append(name).append(" implements org.apache.camel.language.joor.JoorMethod {\n");
        sb.append("\n");
        for (Map.Entry entry : scriptBeans.entrySet()) {
            sb.append("    private ").append(((Class)entry.getValue()).getSimpleName()).append(" ").append((String)entry.getKey()).append(";\n");
        }
        sb.append("\n");
        sb.append("    public ").append(name).append("(CamelContext context) throws Exception {\n");
        for (Map.Entry entry : scriptBeans.entrySet()) {
            sb.append("        ").append((String)entry.getKey()).append(" = ").append("context.getRegistry().lookupByNameAndType(\"").append((String)entry.getKey()).append("\", ").append(((Class)entry.getValue()).getSimpleName()).append(".class);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public Object evaluate(CamelContext context, Exchange exchange, Message message, Object body, Optional optionalBody) throws Exception {\n");
        sb.append("        ");
        if (!script.contains("return ")) {
            sb.append("return ");
        }
        if (biFunction) {
            if (!sb.toString().endsWith("return ")) {
                sb.append("return ");
            }
            sb.append("(BiFunction<Exchange, Exchange, Object>) ");
        }
        if (singleQuotes) {
            String quoted = script.replace('\'', '\"');
            sb.append(quoted);
        } else {
            sb.append(script);
        }
        if (!script.endsWith("}") && !script.endsWith(";")) {
            sb.append(";");
        }
        if (biFunction && !script.endsWith(";")) {
            sb.append(";");
        }
        sb.append("\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("\n");
        return sb.toString();
    }

    private String evalDependencyInjection(CamelContext camelContext, Set<String> scriptImports, Map<String, Class> scriptBeans, String script) {
        Matcher matcher = BEAN_INJECTION_PATTERN.matcher(script);
        while (matcher.find()) {
            String id = matcher.group(2);
            Object bean = CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)id);
            Class<?> type = bean.getClass();
            scriptImports.add(type.getName());
            scriptBeans.put(id, type);
            script = matcher.replaceFirst(id);
            matcher = BEAN_INJECTION_PATTERN.matcher(script);
        }
        return script;
    }

    private String staticHelper(String script) {
        Matcher matcher = BODY_AS_PATTERN.matcher(script);
        script = matcher.replaceAll("$1(message, $2$3)");
        matcher = BODY_AS_PATTERN_NO_CLASS.matcher(script);
        script = matcher.replaceAll("$1(message, $2.class)");
        matcher = HEADER_AS_DEFAULT_VALUE_PATTERN.matcher(script);
        script = matcher.replaceAll("$1(message, $2, $3, $4)");
        matcher = HEADER_AS_DEFAULT_VALUE_PATTERN_NO_CLASS.matcher(script);
        script = matcher.replaceAll("$1(message, $2, $3, $4.class)");
        matcher = HEADER_AS_PATTERN.matcher(script);
        script = matcher.replaceAll("$1(message, $2, $3)");
        matcher = HEADER_AS_PATTERN_NO_CLASS.matcher(script);
        script = matcher.replaceAll("$1(message, $2, $3.class)");
        matcher = EXCHANGE_PROPERTY_AS_DEFAULT_VALUE_PATTERN.matcher(script);
        script = matcher.replaceAll("$1(exchange, $2, $3, $4)");
        matcher = EXCHANGE_PROPERTY_AS_DEFAULT_VALUE_PATTERN_NO_CLASS.matcher(script);
        script = matcher.replaceAll("$1(exchange, $2, $3, $4.class)");
        matcher = EXCHANGE_PROPERTY_AS_PATTERN.matcher(script);
        script = matcher.replaceAll("$1(exchange, $2, $3)");
        matcher = EXCHANGE_PROPERTY_AS_PATTERN_NO_CLASS.matcher(script);
        script = matcher.replaceAll("$1(exchange, $2, $3.class)");
        return script;
    }

    private String alias(String script) {
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            script = script.replace(key, value);
        }
        return script;
    }

    private static String nextFQN() {
        return "org.apache.camel.language.joor.compiled.JoorScript" + UUID.incrementAndGet();
    }
}

