/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaJoorClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaJoorClassLoader.class);
    private final Map<String, Class<?>> classes = new HashMap();
    private String compileDirectory;

    public JavaJoorClassLoader() {
        super(JavaJoorClassLoader.class.getClassLoader());
    }

    public String getCompileDirectory() {
        return this.compileDirectory;
    }

    public void setCompileDirectory(String compileDirectory) {
        this.compileDirectory = compileDirectory;
    }

    @Override
    public String getName() {
        return "JavaJoorClassLoader";
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    public void addClass(String name, Class<?> clazz, byte[] code) {
        if (name != null && clazz != null) {
            this.classes.put(name, clazz);
        }
        if (name != null && code != null && this.compileDirectory != null) {
            JavaJoorClassLoader.saveByteCodeToDisk(this.compileDirectory, name, code);
        }
    }

    private static void saveByteCodeToDisk(String outputDirectory, String name, byte[] byteCode) {
        Object fname = name.replace('.', '/');
        File target = new File((String)(fname = outputDirectory + "/" + (String)fname + ".class"));
        if (!target.exists()) {
            String dir = FileUtil.onlyPath((String)fname);
            new File(dir).mkdirs();
            try {
                FileOutputStream fos = new FileOutputStream(target);
                LOG.debug("Writing compiled class: {} as bytecode to file: {}", (Object)name, (Object)target);
                fos.write(byteCode);
                IOHelper.close((Closeable)fos);
            }
            catch (Exception e) {
                LOG.warn("Error writing compiled class: {} as bytecode to file: {} due to {}. This exception is ignored.", new Object[]{name, target, e.getMessage()});
            }
        }
    }
}

