/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.lang.invoke.MethodHandles;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StaticService;
import org.apache.camel.language.joor.CamelJoorClassLoader;
import org.apache.camel.language.joor.CompilationUnit;
import org.apache.camel.language.joor.JavaJoorClassLoader;
import org.apache.camel.language.joor.JoorCompilationException;
import org.apache.camel.language.joor.JoorScriptingMethod;
import org.apache.camel.language.joor.MultiCompile;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoorScriptingCompiler
extends ServiceSupport
implements StaticService,
CamelContextAware {
    private static final Pattern BEAN_INJECTION_PATTERN = Pattern.compile("(#bean:)([A-Za-z0-9-_]*)");
    private static final Logger LOG = LoggerFactory.getLogger(JoorScriptingCompiler.class);
    private static final AtomicInteger UUID = new AtomicInteger();
    private CamelContext camelContext;
    private JavaJoorClassLoader classLoader;
    private Set<String> imports = new TreeSet<String>();
    private Map<String, String> aliases;
    private int counter;
    private long taken;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    protected void doBuild() throws Exception {
        CamelContext context = this.getCamelContext();
        if (context != null) {
            CompileStrategy cs;
            this.classLoader = (JavaJoorClassLoader)context.getClassResolver().getClassLoader("JavaJoorClassLoader");
            if (this.classLoader == null) {
                this.classLoader = new JavaJoorClassLoader();
                context.getClassResolver().addClassLoader((ClassLoader)this.classLoader);
            }
            if ((cs = (CompileStrategy)context.getCamelContextExtension().getContextPlugin(CompileStrategy.class)) != null && cs.getWorkDir() != null) {
                this.classLoader.setCompileDirectory(cs.getWorkDir());
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.counter > 0) {
            LOG.info("Java language compiled {} scripts in {} millis", (Object)this.counter, (Object)this.taken);
        }
    }

    public JoorScriptingMethod compile(CamelContext camelContext, String script, Map<String, Object> bindings, boolean singleQuotes) {
        JoorScriptingMethod answer;
        StopWatch watch = new StopWatch();
        String className = JoorScriptingCompiler.nextFQN();
        String code = this.evalCode(camelContext, className, script, bindings, singleQuotes);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compiling code:\n\n{}\n", (Object)code);
            }
            CompilationUnit unit = CompilationUnit.input();
            unit.addClass(className, code);
            ClassLoader parent = MethodHandles.lookup().lookupClass().getClassLoader();
            if (parent instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)parent;
                CamelJoorClassLoader cl = new CamelJoorClassLoader(ucl, camelContext);
                unit.withClassLoader(cl);
            }
            LOG.debug("Compiling: {}", (Object)className);
            CompilationUnit.Result result = MultiCompile.compileUnit(unit);
            Class<?> clazz = result.getClass(className);
            if (clazz != null) {
                LOG.debug("Compiled to Java class: {}", clazz);
                answer = (JoorScriptingMethod)clazz.getConstructor(CamelContext.class).newInstance(camelContext);
            } else {
                answer = null;
            }
        }
        catch (Exception e) {
            throw new JoorCompilationException(className, code, e);
        }
        ++this.counter;
        this.taken += watch.taken();
        return answer;
    }

    public String evalCode(CamelContext camelContext, String fqn, String script, Map<String, Object> bindings, boolean singleQuotes) {
        String qn = fqn.substring(0, fqn.lastIndexOf(46));
        String name = fqn.substring(fqn.lastIndexOf(46) + 1);
        script = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (String)script);
        script = script.trim();
        boolean biFunction = script.startsWith("(e1, e2) ->");
        LinkedHashSet<String> scriptImports = new LinkedHashSet<String>();
        HashMap<String, Class> scriptBeans = new HashMap<String, Class>();
        script = this.evalDependencyInjection(camelContext, scriptImports, scriptBeans, script);
        StringBuilder sb = new StringBuilder(4096);
        sb.append("package ").append(qn).append(";\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.util.concurrent.*;\n");
        sb.append("import java.util.function.*;\n");
        sb.append("import java.util.stream.*;\n");
        sb.append("\n");
        sb.append("import org.apache.camel.*;\n");
        sb.append("import org.apache.camel.util.*;\n");
        sb.append("import static org.apache.camel.language.joor.JoorHelper.*;\n");
        sb.append("\n");
        for (String string : this.imports) {
            sb.append(string);
            if (!string.endsWith(";")) {
                sb.append(";");
            }
            sb.append("\n");
        }
        for (String string : scriptImports) {
            sb.append("import ");
            sb.append(string);
            sb.append(";\n");
        }
        sb.append("\n");
        sb.append("public class ").append(name).append(" implements org.apache.camel.language.joor.JoorScriptingMethod {\n");
        sb.append("\n");
        for (Map.Entry entry : scriptBeans.entrySet()) {
            sb.append("    private ").append(((Class)entry.getValue()).getSimpleName()).append(" ").append((String)entry.getKey()).append(";\n");
        }
        sb.append("\n");
        sb.append("    public ").append(name).append("(CamelContext context) throws Exception {\n");
        for (Map.Entry entry : scriptBeans.entrySet()) {
            sb.append("        ").append((String)entry.getKey()).append(" = ").append("context.getRegistry().lookupByNameAndType(\"").append((String)entry.getKey()).append("\", ").append(((Class)entry.getValue()).getSimpleName()).append(".class);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public Object evaluate(Map<String, Object> args) throws Exception {\n");
        sb.append("        ");
        if (bindings != null) {
            for (Map.Entry entry : bindings.entrySet()) {
                String vn = (String)entry.getKey();
                String cn = ObjectHelper.className(entry.getValue());
                String b = String.format("        var %s = (%s) args.get(\"%s\");%n", vn, cn, vn);
                sb.append(b);
            }
            sb.append("\n");
        }
        if (!script.contains("return ")) {
            sb.append("return ");
        }
        if (biFunction) {
            if (!sb.toString().endsWith("return ")) {
                sb.append("return ");
            }
            sb.append("(BiFunction<Exchange, Exchange, Object>) ");
        }
        if (singleQuotes) {
            String quoted = script.replace('\'', '\"');
            sb.append(quoted);
        } else {
            sb.append(script);
        }
        if (!script.endsWith("}") && !script.endsWith(";")) {
            sb.append(";");
        }
        if (biFunction && !script.endsWith(";")) {
            sb.append(";");
        }
        sb.append("\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("\n");
        return sb.toString();
    }

    private String evalDependencyInjection(CamelContext camelContext, Set<String> scriptImports, Map<String, Class> scriptBeans, String script) {
        Matcher matcher = BEAN_INJECTION_PATTERN.matcher(script);
        while (matcher.find()) {
            String id = matcher.group(2);
            Object bean = CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)id);
            Class<?> type = bean.getClass();
            scriptImports.add(type.getName());
            scriptBeans.put(id, type);
            script = matcher.replaceFirst(id);
            matcher = BEAN_INJECTION_PATTERN.matcher(script);
        }
        return script;
    }

    private static String nextFQN() {
        return "org.apache.camel.language.joor.compiled.scripting.JoorScripting" + UUID.incrementAndGet();
    }
}

