/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaTemplateTransactionStrategy
implements TransactionStrategy {
    private final JpaTemplate jpaTemplate;
    private final TransactionTemplate transactionTemplate;

    public JpaTemplateTransactionStrategy(JpaTemplate jpaTemplate, TransactionTemplate transactionTemplate) {
        this.jpaTemplate = jpaTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public static JpaTemplateTransactionStrategy newInstance(EntityManagerFactory emf) {
        JpaTemplate template = new JpaTemplate(emf);
        return JpaTemplateTransactionStrategy.newInstance(emf, template);
    }

    public static JpaTemplateTransactionStrategy newInstance(EntityManagerFactory emf, JpaTemplate template) {
        JpaTransactionManager transactionManager = new JpaTransactionManager(emf);
        transactionManager.afterPropertiesSet();
        TransactionTemplate tranasctionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        tranasctionTemplate.afterPropertiesSet();
        return new JpaTemplateTransactionStrategy(template, tranasctionTemplate);
    }

    public static JpaTemplateTransactionStrategy newInstance(PlatformTransactionManager transactionManager, JpaTemplate template) {
        TransactionTemplate tranasctionTemplate = new TransactionTemplate(transactionManager);
        tranasctionTemplate.afterPropertiesSet();
        return new JpaTemplateTransactionStrategy(template, tranasctionTemplate);
    }

    @Override
    public Object execute(final JpaCallback<?> callback) {
        return this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                return JpaTemplateTransactionStrategy.this.jpaTemplate.execute((JpaCallback)new JpaCallback<Object>(){

                    public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                        return callback.doInJpa(entityManager);
                    }
                });
            }
        });
    }
}

