/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Hashtable;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.component.jpa.JpaConsumer;
import org.apache.camel.component.jpa.JpaProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalEntityManagerFactoryBean;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@UriEndpoint(scheme="jpa", title="JPA", syntax="jpa:entityType", consumerClass=JpaConsumer.class, label="database,sql")
public class JpaEndpoint
extends ScheduledPollEndpoint {
    private EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;
    private Expression producerExpression;
    private Map<String, Object> entityManagerProperties;
    @UriPath(description="Entity class name")
    @Metadata(required="true")
    private Class<?> entityType;
    @UriParam(defaultValue="camel")
    @Metadata(required="true")
    private String persistenceUnit = "camel";
    @UriParam(defaultValue="true")
    private boolean joinTransaction = true;
    @UriParam
    private boolean sharedEntityManager;
    @UriParam(label="consumer", defaultValue="-1")
    private int maximumResults = -1;
    @UriParam(label="consumer", defaultValue="true")
    private boolean consumeDelete = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean consumeLockEntity = true;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam(label="producer", defaultValue="true")
    private boolean flushOnSend = true;
    @UriParam(label="producer")
    private boolean usePersist;
    @UriParam(label="producer")
    private boolean usePassedInEntityManager;
    @UriParam(label="producer")
    private boolean remove;

    public JpaEndpoint() {
    }

    @Deprecated
    public JpaEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public JpaEndpoint(String uri, JpaComponent component) {
        super(uri, (Component)component);
        this.entityManagerFactory = component.getEntityManagerFactory();
        this.transactionManager = component.getTransactionManager();
    }

    @Deprecated
    public JpaEndpoint(String endpointUri, EntityManagerFactory entityManagerFactory) {
        super(endpointUri);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Deprecated
    public JpaEndpoint(String endpointUri, EntityManagerFactory entityManagerFactory, PlatformTransactionManager transactionManager) {
        super(endpointUri);
        this.entityManagerFactory = entityManagerFactory;
        this.transactionManager = transactionManager;
    }

    public Producer createProducer() throws Exception {
        this.validate();
        return new JpaProducer(this, this.getProducerExpression());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validate();
        JpaConsumer consumer = new JpaConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        Map emProperties = IntrospectionSupport.extractProperties(options, (String)"emf.");
        if (emProperties != null) {
            this.setEntityManagerProperties(emProperties);
        }
    }

    public boolean isSingleton() {
        return false;
    }

    protected String createEndpointUri() {
        return "jpa" + (this.entityType != null ? "://" + this.entityType.getName() : "");
    }

    public Expression getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    public void setProducerExpression(Expression producerExpression) {
        this.producerExpression = producerExpression;
    }

    public int getMaximumResults() {
        return this.maximumResults;
    }

    public void setMaximumResults(int maximumResults) {
        this.maximumResults = maximumResults;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.createEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = this.createTransactionManager();
        }
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Map<String, Object> getEntityManagerProperties() {
        if (this.entityManagerProperties == null) {
            this.entityManagerProperties = CastUtils.cast((Hashtable)System.getProperties());
        }
        return this.entityManagerProperties;
    }

    public void setEntityManagerProperties(Map<String, Object> entityManagerProperties) {
        this.entityManagerProperties = entityManagerProperties;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public boolean isConsumeDelete() {
        return this.consumeDelete;
    }

    public void setConsumeDelete(boolean consumeDelete) {
        this.consumeDelete = consumeDelete;
    }

    public boolean isConsumeLockEntity() {
        return this.consumeLockEntity;
    }

    public void setConsumeLockEntity(boolean consumeLockEntity) {
        this.consumeLockEntity = consumeLockEntity;
    }

    public boolean isFlushOnSend() {
        return this.flushOnSend;
    }

    public void setFlushOnSend(boolean flushOnSend) {
        this.flushOnSend = flushOnSend;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public boolean isUsePersist() {
        return this.usePersist;
    }

    public void setUsePersist(boolean usePersist) {
        this.usePersist = usePersist;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean isRemove) {
        this.remove = isRemove;
    }

    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public boolean isUsePassedInEntityManager() {
        return this.usePassedInEntityManager;
    }

    public void setUsePassedInEntityManager(boolean usePassedIn) {
        this.usePassedInEntityManager = usePassedIn;
    }

    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    protected void validate() {
        ObjectHelper.notNull((Object)this.getEntityManagerFactory(), (String)"entityManagerFactory");
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        LocalEntityManagerFactoryBean emfBean = new LocalEntityManagerFactoryBean();
        emfBean.setPersistenceUnitName(this.persistenceUnit);
        emfBean.setJpaPropertyMap(this.getEntityManagerProperties());
        emfBean.afterPropertiesSet();
        return emfBean.getObject();
    }

    protected PlatformTransactionManager createTransactionManager() {
        JpaTransactionManager tm = new JpaTransactionManager(this.getEntityManagerFactory());
        tm.afterPropertiesSet();
        return tm;
    }

    @Deprecated
    protected EntityManager createEntityManager() {
        if (this.sharedEntityManager) {
            return SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.getEntityManagerFactory());
        }
        return this.getEntityManagerFactory().createEntityManager();
    }

    protected TransactionTemplate createTransactionTemplate() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
        transactionTemplate.setPropagationBehavior(0);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }

    protected Expression createProducerExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object answer;
                try {
                    answer = JpaEndpoint.this.getEntityType() == null ? exchange.getIn().getMandatoryBody() : exchange.getIn().getMandatoryBody(JpaEndpoint.this.getEntityType());
                }
                catch (InvalidPayloadException e) {
                    throw new InvalidPayloadRuntimeException(exchange, JpaEndpoint.this.getEntityType(), e.getCause());
                }
                return answer;
            }
        };
    }
}

