/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.component.jpa.JpaCloseEntityManagerOnCompletion;
import org.apache.camel.spi.Synchronization;
import org.springframework.orm.jpa.SharedEntityManagerCreator;

public final class JpaHelper {
    private JpaHelper() {
    }

    public static EntityManager getTargetEntityManager(Exchange exchange, EntityManagerFactory entityManagerFactory, boolean usePassedInEntityManager, boolean useSharedEntityManager, boolean allowRecreate) {
        EntityManager em = null;
        if (exchange != null && usePassedInEntityManager) {
            em = (EntityManager)exchange.getIn().getHeader("CamelEntityManager", EntityManager.class);
        }
        if (em == null && exchange != null) {
            em = (EntityManager)exchange.getProperty("CamelEntityManager", EntityManager.class);
        }
        if (em == null && useSharedEntityManager) {
            em = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)entityManagerFactory);
        }
        if (em == null) {
            em = entityManagerFactory.createEntityManager();
            if (exchange != null) {
                exchange.setProperty("CamelEntityManager", (Object)em);
                exchange.addOnCompletion((Synchronization)new JpaCloseEntityManagerOnCompletion(em));
            }
        }
        if (allowRecreate && em == null || !em.isOpen()) {
            em = entityManagerFactory.createEntityManager();
            if (exchange != null) {
                exchange.setProperty("CamelEntityManager", (Object)em);
                exchange.addOnCompletion((Synchronization)new JpaCloseEntityManagerOnCompletion(em));
            }
        }
        return em;
    }
}

