/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.component.jpa.JpaCloseEntityManagerOnCompletion;
import org.apache.camel.spi.Synchronization;
import org.springframework.orm.jpa.SharedEntityManagerCreator;

public final class JpaHelper {
    private JpaHelper() {
    }

    public static EntityManager getTargetEntityManager(Exchange exchange, EntityManagerFactory entityManagerFactory, boolean usePassedInEntityManager, boolean useSharedEntityManager, boolean allowRecreate) {
        EntityManager em = null;
        if (exchange != null && usePassedInEntityManager) {
            em = (EntityManager)exchange.getIn().getHeader("CamelEntityManager", EntityManager.class);
        }
        if (em == null && exchange != null) {
            em = JpaHelper.getEntityManagerMap(exchange).get(JpaHelper.getKey(entityManagerFactory));
        }
        if (em == null && useSharedEntityManager) {
            em = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)entityManagerFactory);
        }
        if (em == null) {
            em = JpaHelper.createEntityManager(exchange, entityManagerFactory);
        }
        if (allowRecreate && em == null || !em.isOpen()) {
            em = JpaHelper.createEntityManager(exchange, entityManagerFactory);
        }
        return em;
    }

    private static EntityManager createEntityManager(Exchange exchange, EntityManagerFactory entityManagerFactory) {
        EntityManager em = entityManagerFactory.createEntityManager();
        if (exchange != null) {
            Map<String, EntityManager> entityManagers = JpaHelper.getEntityManagerMap(exchange);
            entityManagers.put(JpaHelper.getKey(entityManagerFactory), em);
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new JpaCloseEntityManagerOnCompletion(em));
        }
        return em;
    }

    private static Map<String, EntityManager> getEntityManagerMap(Exchange exchange) {
        HashMap entityManagers = (HashMap)exchange.getProperty("CamelEntityManager", Map.class);
        if (entityManagers == null) {
            entityManagers = new HashMap();
            exchange.setProperty("CamelEntityManager", entityManagers);
        }
        return entityManagers;
    }

    private static String getKey(EntityManagerFactory entityManagerFactory) {
        return String.valueOf(entityManagerFactory.hashCode());
    }
}

