/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaProducer.class);
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionTemplate transactionTemplate;
    private final Expression expression;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private boolean findEntity;
    private Map<String, Object> parameters;
    private Class<?> resultClass;
    private QueryFactory queryFactory;
    private Boolean useExecuteUpdate;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.expression = expression;
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionTemplate = endpoint.createTransactionTemplate();
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            if (this.query != null) {
                this.queryFactory = QueryBuilder.query(this.query);
            } else if (this.namedQuery != null) {
                this.queryFactory = QueryBuilder.namedQuery(this.namedQuery);
            } else if (this.nativeQuery != null) {
                this.queryFactory = this.resultClass != null ? QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass) : QueryBuilder.nativeQuery(this.nativeQuery);
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isFindEntity() {
        return this.findEntity;
    }

    public void setFindEntity(boolean findEntity) {
        this.findEntity = findEntity;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public void setUseExecuteUpdate(Boolean executeUpdate) {
        this.useExecuteUpdate = executeUpdate;
    }

    public boolean isUseExecuteUpdate() {
        if (this.useExecuteUpdate == null) {
            this.useExecuteUpdate = this.query != null ? (this.query.regionMatches(true, 0, "select", 0, 6) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : (this.nativeQuery != null ? (this.nativeQuery.regionMatches(true, 0, "select", 0, 6) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(false));
        }
        return this.useExecuteUpdate;
    }

    public void process(Exchange exchange) {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, this.getEndpoint().isUsePassedInEntityManager(), this.getEndpoint().isSharedEntityManager(), true);
        if (this.findEntity) {
            this.processFind(exchange, entityManager);
        } else if (this.getQueryFactory() != null) {
            this.processQuery(exchange, entityManager);
        } else {
            this.processEntity(exchange, entityManager);
        }
    }

    protected void processQuery(final Exchange exchange, final EntityManager entityManager) {
        final Query query = this.getQueryFactory().createQuery(entityManager);
        this.configureParameters(query, exchange);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                Message target;
                if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                    target = exchange.getOut();
                    target.getHeaders().putAll(exchange.getIn().getHeaders());
                } else {
                    target = exchange.getIn();
                }
                Object answer = JpaProducer.this.isUseExecuteUpdate() ? Integer.valueOf(query.executeUpdate()) : query.getResultList();
                target.setBody(answer);
                if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                    entityManager.flush();
                }
                return null;
            }
        });
    }

    private void configureParameters(Query query, Exchange exchange) {
        Map params;
        int maxResults = this.getEndpoint().getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if ((params = this.parameters != null ? this.parameters : (Map)exchange.getIn().getHeader("CamelJpaParameters", Map.class)) != null) {
            params.forEach((key, value) -> {
                Object resolvedValue = value;
                if (value instanceof String) {
                    resolvedValue = SimpleLanguage.expression((String)((String)value)).evaluate(exchange, Object.class);
                }
                query.setParameter(key, resolvedValue);
            });
        }
    }

    protected void processFind(final Exchange exchange, final EntityManager entityManager) {
        final Object key = exchange.getMessage().getBody();
        if (key != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    Message target;
                    if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                        entityManager.joinTransaction();
                    }
                    Object answer = entityManager.find(JpaProducer.this.getEndpoint().getEntityType(), key);
                    LOG.debug("Find: {} -> {}", key, answer);
                    if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                        target = exchange.getOut();
                        target.getHeaders().putAll(exchange.getIn().getHeaders());
                    } else {
                        target = exchange.getIn();
                    }
                    target.setBody(answer);
                    if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                        entityManager.flush();
                    }
                    return null;
                }
            });
        }
    }

    protected void processEntity(final Exchange exchange, final EntityManager entityManager) {
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                        entityManager.joinTransaction();
                    }
                    if (values.getClass().isArray()) {
                        Object[] array = (Object[])values;
                        Object[] managedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            Object element = array[i];
                            Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(element) : this.remove(element);
                            managedArray[i] = managedEntity;
                        }
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            System.arraycopy(managedArray, 0, array, 0, array.length);
                            exchange.getIn().setBody((Object)array);
                        }
                    } else if (values instanceof Collection) {
                        Collection collection = (Collection)values;
                        ArrayList<Object> managedCollection = new ArrayList<Object>(collection.size());
                        for (Object entity : collection) {
                            Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(entity) : this.remove(entity);
                            managedCollection.add(managedEntity);
                        }
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            exchange.getIn().setBody(managedCollection);
                        }
                    } else {
                        Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(values) : this.remove(values);
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            exchange.getIn().setBody(managedEntity);
                        }
                    }
                    if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                        entityManager.flush();
                    }
                    return null;
                }

                private Object save(Object entity) {
                    LOG.debug("save: {}", entity);
                    if (JpaProducer.this.getEndpoint().isUsePersist()) {
                        entityManager.persist(entity);
                        return entity;
                    }
                    return entityManager.merge(entity);
                }

                private Object remove(Object entity) {
                    LOG.debug("remove: {}", entity);
                    Object managedEntity = entityManager.contains(entity) ? entity : entityManager.merge(entity);
                    entityManager.remove(managedEntity);
                    return managedEntity;
                }
            });
        }
    }
}

