/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import javax.persistence.EntityManagerFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultTransactionStrategy
implements TransactionStrategy {
    private final TransactionTemplate transactionTemplate;
    private final PlatformTransactionManager transactionManager;
    private final EntityManagerFactory entityManagerFactory;

    public DefaultTransactionStrategy(PlatformTransactionManager transactionManager, EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.transactionManager = transactionManager == null ? this.createTransactionManager(entityManagerFactory) : transactionManager;
        this.transactionTemplate = this.createTransactionTemplate();
    }

    @Override
    public void executeInTransaction(final Runnable runnable) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                runnable.run();
                return null;
            }
        });
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected PlatformTransactionManager createTransactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.afterPropertiesSet();
        return tm;
    }

    protected TransactionTemplate createTransactionTemplate() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
        transactionTemplate.setPropagationBehavior(0);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }
}

