/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq;

import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.module.ModuleLoader;
import net.thisptr.jackson.jq.module.loaders.BuiltinModuleLoader;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.language.jq.JqExpression;
import org.apache.camel.language.jq.JqFunctions;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.util.ObjectHelper;

@Language(value="jq")
public class JqLanguage
extends SingleInputTypedLanguageSupport
implements StaticService {
    private Scope rootScope;

    public void init() {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)((Object)this));
        if (this.rootScope == null) {
            this.rootScope = Scope.newEmptyScope();
            this.rootScope.setModuleLoader((ModuleLoader)BuiltinModuleLoader.getInstance());
            JqFunctions.load(this.getCamelContext(), this.rootScope);
            JqFunctions.loadLocal(this.rootScope);
        }
    }

    public Scope getRootScope() {
        return this.rootScope;
    }

    public void start() {
    }

    public void stop() {
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression, properties));
    }

    public Expression createExpression(String expression) {
        JqExpression answer = new JqExpression(Scope.newChildScope((Scope)this.rootScope), expression);
        answer.setResultType(this.getResultType());
        answer.setHeaderName(this.getHeaderName());
        answer.setPropertyName(this.getPropertyName());
        answer.init(this.getCamelContext());
        return answer;
    }

    public Expression createExpression(String expression, Object[] properties) {
        JqExpression answer = new JqExpression(Scope.newChildScope((Scope)this.rootScope), expression);
        answer.setResultType((Class)this.property(Class.class, properties, 0, this.getResultType()));
        answer.setHeaderName((String)this.property(String.class, properties, 1, this.getHeaderName()));
        answer.setPropertyName((String)this.property(String.class, properties, 2, this.getPropertyName()));
        answer.init(this.getCamelContext());
        return answer;
    }
}

