/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.js;

import java.io.Reader;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.dsl.js.JavaScriptDSL;
import org.apache.camel.dsl.support.EndpointRouteBuilderLoaderSupport;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.LifecycleStrategySupport;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

@ManagedResource(description="Managed JavaScriptRoutesBuilderLoader")
@RoutesLoader(value="js")
public class JavaScriptRoutesBuilderLoader
extends EndpointRouteBuilderLoaderSupport {
    public static final String EXTENSION = "js";
    public static final String LANGUAGE_ID = "js";

    public JavaScriptRoutesBuilderLoader() {
        super("js");
    }

    protected void doLoadEndpointRouteBuilder(Reader reader, EndpointRouteBuilder builder) {
        final Context context = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).build();
        Value bindings = context.getBindings("js");
        bindings.putMember("__dsl", (Object)new JavaScriptDSL(builder));
        context.eval("js", (CharSequence)String.join((CharSequence)"\n", "Object.setPrototypeOf(globalThis, new Proxy(Object.prototype, {", "    has(target, key) {", "        return key in __dsl || key in target;", "    },", "    get(target, key, receiver) {", "        return Reflect.get((key in __dsl) ? __dsl : target, key, receiver);", "    }", "}));"));
        context.eval(Source.newBuilder((String)"js", (Reader)reader, (String)"Unnamed").buildLiteral());
        builder.getContext().addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextStopping(CamelContext camelContext) {
                context.close(true);
            }
        });
    }
}

