/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.js;

import java.io.Reader;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.dsl.js.JavaScriptDSL;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.RoutesBuilderLoaderSupport;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

@ManagedResource(description="Managed JavaScriptRoutesBuilderLoader")
@RoutesLoader(value="js")
public class JavaScriptRoutesBuilderLoader
extends RoutesBuilderLoaderSupport {
    public static final String EXTENSION = "js";
    public static final String LANGUAGE_ID = "js";
    private StartupStepRecorder recorder;

    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.getCamelContext() != null) {
            this.recorder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
        }
    }

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return "js";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutesBuilder loadRoutesBuilder(Resource resource) throws Exception {
        StartupStep step = this.recorder != null ? this.recorder.beginStep(JavaScriptRoutesBuilderLoader.class, resource.getLocation(), "Compiling RouteBuilder") : null;
        try {
            EndpointRouteBuilder endpointRouteBuilder = EndpointRouteBuilder.loadEndpointRoutesBuilder((Resource)resource, this::load);
            return endpointRouteBuilder;
        }
        finally {
            if (this.recorder != null) {
                this.recorder.endStep(step);
            }
        }
    }

    private void load(Reader reader, EndpointRouteBuilder builder) {
        final Context context = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).build();
        Value bindings = context.getBindings("js");
        bindings.putMember("__dsl", (Object)new JavaScriptDSL(builder));
        context.eval("js", (CharSequence)String.join((CharSequence)"\n", "Object.setPrototypeOf(globalThis, new Proxy(Object.prototype, {", "    has(target, key) {", "        return key in __dsl || key in target;", "    },", "    get(target, key, receiver) {", "        return Reflect.get((key in __dsl) ? __dsl : target, key, receiver);", "    }", "}));"));
        context.eval(Source.newBuilder((String)"js", (Reader)reader, (String)"Unnamed").buildLiteral());
        builder.getContext().addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextStopping(CamelContext camelContext) {
                context.close(true);
            }
        });
    }
}

