/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.jsch.ScpConfiguration;
import org.apache.camel.component.jsch.ScpEndpoint;
import org.apache.camel.component.jsch.ScpFile;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpOperations
implements RemoteFileOperations<ScpFile> {
    private static final String DEFAULT_KNOWN_HOSTS = "META-INF/.ssh/known_hosts";
    private static final Logger LOG = LoggerFactory.getLogger(ScpOperations.class);
    private ScpEndpoint endpoint;
    private Session session;
    private ChannelExec channel;

    public void setEndpoint(GenericFileEndpoint<ScpFile> endpoint) {
        this.endpoint = (ScpEndpoint)endpoint;
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'delete' not supported by the scp: protocol");
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        return false;
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'rename' not supported by the scp: protocol");
    }

    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        return true;
    }

    public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        return false;
    }

    public void releaseRetreivedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
    }

    public boolean storeFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        ObjectHelper.notNull((Object)this.session, (String)"session");
        ScpConfiguration cfg = this.endpoint.getConfiguration();
        int timeout = cfg.getConnectTimeout();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Opening channel to {} with {} timeout...", (Object)cfg.remoteServerInformation(), (Object)(timeout > 0 ? Integer.toString(timeout) + " ms" : "no"));
        }
        String file = ScpOperations.getRemoteFile(name, cfg);
        InputStream is = null;
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                LOG.trace("Writing empty file.");
                is = new ByteArrayInputStream(new byte[0]);
            } else {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
        }
        try {
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(ScpOperations.getScpCommand(cfg, file));
            this.channel.connect(timeout);
            LOG.trace("Channel connected to {}", (Object)cfg.remoteServerInformation());
            try {
                if (is == null) {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                }
                this.write(this.channel, file, is, cfg);
            }
            catch (InvalidPayloadException e) {
                throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException("Failed to write file " + file, (Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        catch (JSchException e) {
            throw new GenericFileOperationFailedException("Failed to write file " + file, (Throwable)e);
        }
        finally {
            if (this.channel != null) {
                LOG.trace("Disconnecting 'exec' scp channel");
                this.channel.disconnect();
                this.channel = null;
                LOG.trace("Channel disconnected from {}", (Object)cfg.remoteServerInformation());
            }
        }
        return true;
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return this.endpoint.getConfiguration().getDirectory();
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'cd " + path + "' not supported by the scp: protocol");
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'cd ..' not supported by the scp: protocol");
    }

    public List<ScpFile> listFiles() throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'ls' not supported by the scp: protocol");
    }

    public List<ScpFile> listFiles(String path) throws GenericFileOperationFailedException {
        throw new GenericFileOperationFailedException("Operation 'ls " + path + "' not supported by the scp: protocol");
    }

    public boolean connect(RemoteFileConfiguration configuration) throws GenericFileOperationFailedException {
        if (!this.isConnected()) {
            this.session = this.createSession(configuration instanceof ScpConfiguration ? (ScpConfiguration)configuration : null);
            if (!this.isConnected()) {
                this.session = null;
                throw new GenericFileOperationFailedException("Failed to connect to " + configuration.remoteServerInformation());
            }
        }
        return true;
    }

    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.session != null && this.session.isConnected();
    }

    public void disconnect() throws GenericFileOperationFailedException {
        if (this.isConnected()) {
            this.session.disconnect();
        }
        this.session = null;
    }

    public boolean sendNoop() throws GenericFileOperationFailedException {
        return true;
    }

    public boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        return true;
    }

    private Session createSession(ScpConfiguration config) {
        ObjectHelper.notNull((Object)((Object)config), (String)"ScpConfiguration");
        try {
            String knownHostsFile;
            JSch jsch = new JSch();
            if (ObjectHelper.isNotEmpty((Object)config.getCiphers())) {
                LOG.debug("Using ciphers: {}", (Object)config.getCiphers());
                Hashtable<String, String> ciphers = new Hashtable<String, String>();
                ciphers.put("cipher.s2c", config.getCiphers());
                ciphers.put("cipher.c2s", config.getCiphers());
                JSch.setConfig(ciphers);
            }
            if (ObjectHelper.isNotEmpty((Object)config.getPrivateKeyFile())) {
                LOG.debug("Using private keyfile: {}", (Object)config.getPrivateKeyFile());
                String pkfp = config.getPrivateKeyFilePassphrase();
                jsch.addIdentity(config.getPrivateKeyFile(), ObjectHelper.isNotEmpty((Object)pkfp) ? pkfp : null);
            }
            jsch.setKnownHosts(ObjectHelper.isEmpty((Object)(knownHostsFile = config.getKnownHostsFile())) ? DEFAULT_KNOWN_HOSTS : knownHostsFile);
            this.session = jsch.getSession(config.getUsername(), config.getHost(), config.getPort());
            this.session.setTimeout(config.getTimeout());
            this.session.setUserInfo((UserInfo)new SessionUserInfo(config));
            int timeout = config.getConnectTimeout();
            LOG.debug("Connecting to {} with {} timeout...", (Object)config.remoteServerInformation(), (Object)(timeout > 0 ? Integer.toString(timeout) + " ms" : "no"));
            if (timeout > 0) {
                this.session.connect(timeout);
            } else {
                this.session.connect();
            }
        }
        catch (JSchException e) {
            this.session = null;
            LOG.warn("Could not create ssh session for " + config.remoteServerInformation(), (Throwable)e);
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ChannelExec c, String name, InputStream data, ScpConfiguration cfg) throws IOException {
        OutputStream os = c.getOutputStream();
        InputStream is = c.getInputStream();
        try {
            this.writeFile(name, data, os, is, cfg);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, os});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, os});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String filename, InputStream data, OutputStream os, InputStream is, ScpConfiguration cfg) throws IOException {
        int lineFeed = 10;
        int pos = filename.indexOf(47);
        if (pos >= 0) {
            String dir = filename.substring(0, pos);
            String bytes = "D0775 0 " + dir;
            LOG.trace("[scp:sink] {}", (Object)bytes);
            os.write(bytes.getBytes());
            os.write(10);
            os.flush();
            this.readAck(is, false);
            this.writeFile(filename.substring(pos + 1), data, os, is, cfg);
            bytes = "E";
            LOG.trace("[scp:sink] {}", (Object)bytes);
            os.write(bytes.getBytes());
            os.write(10);
            os.flush();
            this.readAck(is, false);
        } else {
            int count = 0;
            int size = this.endpoint.getBufferSize();
            byte[] reply = new byte[size];
            BufferedInputStream buffer = new BufferedInputStream(data, size);
            try {
                int read;
                buffer.mark(Integer.MAX_VALUE);
                while ((read = buffer.read(reply)) != -1) {
                    count += read;
                }
                String bytes = "C0" + cfg.getChmod() + " " + count + " " + filename;
                LOG.trace("[scp:sink] {}", (Object)bytes);
                os.write(bytes.getBytes());
                os.write(10);
                os.flush();
                this.readAck(is, false);
                buffer.reset();
                while ((read = buffer.read(reply)) != -1) {
                    os.write(reply, 0, read);
                }
                this.writeAck(os);
                this.readAck(is, false);
            }
            finally {
                IOHelper.close((Closeable)buffer);
            }
        }
    }

    private void writeAck(OutputStream os) throws IOException {
        os.write(0);
        os.flush();
    }

    private int readAck(InputStream is, boolean failOnEof) throws IOException {
        int answer = is.read();
        switch (answer) {
            case -1: {
                if (!failOnEof) break;
                String message = "[scp] Unexpected end of stream";
                throw new EOFException(message);
            }
            case 1: {
                String message = "[scp] WARN " + this.readLine(is);
                LOG.warn(message);
                break;
            }
            case 2: {
                String message = "[scp] NACK " + this.readLine(is);
                throw new IOException(message);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(InputStream is) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            int c;
            do {
                if ((c = is.read()) == 10) {
                    String string = bytes.toString();
                    return string;
                }
                bytes.write(c);
            } while (c != -1);
        }
        finally {
            IOHelper.close((Closeable)bytes);
        }
        String message = "[scp] Unexpected end of stream";
        throw new IOException(message);
    }

    private static String getRemoteTarget(ScpConfiguration config) {
        return config.getDirectory().isEmpty() ? "." : config.getDirectory();
    }

    private static String getRemoteFile(String name, ScpConfiguration config) {
        String dir = config.getDirectory();
        dir = dir.endsWith("/") ? dir : dir + "/";
        return name.startsWith(dir) ? name.substring(dir.length()) : name;
    }

    private static boolean isRecursiveScp(String name) {
        return name.indexOf(47) > 0;
    }

    private static String getScpCommand(ScpConfiguration config, String name) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("scp ");
        cmd.append(ScpOperations.isRecursiveScp(name) ? "-r " : "");
        cmd.append("-t ");
        cmd.append(ScpOperations.getRemoteTarget(config));
        return cmd.toString();
    }

    protected static final class SessionUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final ScpConfiguration config;

        public SessionUserInfo(ScpConfiguration config) {
            ObjectHelper.notNull((Object)((Object)config), (String)"config");
            this.config = config;
        }

        public String getPassphrase() {
            LOG.warn("Private Key authentication not supported");
            return null;
        }

        public String getPassword() {
            LOG.debug("Providing password for ssh authentication of user '{}'", (Object)this.config.getUsername());
            return this.config.getPassword();
        }

        public boolean promptPassword(String message) {
            LOG.debug(message);
            return true;
        }

        public boolean promptPassphrase(String message) {
            LOG.debug(message);
            return true;
        }

        public boolean promptYesNo(String message) {
            LOG.debug(message);
            return false;
        }

        public void showMessage(String message) {
            LOG.debug(message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            LOG.debug(instruction);
            return null;
        }
    }
}

