/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import java.net.URI;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class ScpConfiguration
extends RemoteFileConfiguration {
    public static final int DEFAULT_SFTP_PORT = 22;
    public static final String DEFAULT_MOD = "664";
    @UriParam(label="security", defaultValue="true")
    private boolean useUserKnownHostsFile = true;
    @UriParam(label="security", secret=true)
    private String knownHostsFile;
    @UriParam(label="security", secret=true)
    private String privateKeyFile;
    @UriParam(label="security", secret=true)
    private byte[] privateKeyBytes;
    @UriParam(label="security", secret=true)
    private String privateKeyFilePassphrase;
    @UriParam(enums="no,yes", defaultValue="no")
    private String strictHostKeyChecking = "no";
    @UriParam(defaultValue="664")
    private String chmod = "664";
    @UriParam(label="security,advanced")
    private String ciphers;
    @UriParam(label="security", secret=true)
    private String preferredAuthentications;

    public ScpConfiguration() {
        this.setProtocol("scp");
    }

    public ScpConfiguration(URI uri) {
        super(uri);
    }

    protected void setDefaultPort() {
        this.setPort(22);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public boolean isUseUserKnownHostsFile() {
        return this.useUserKnownHostsFile;
    }

    public void setUseUserKnownHostsFile(boolean useUserKnownHostsFile) {
        this.useUserKnownHostsFile = useUserKnownHostsFile;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public byte[] getPrivateKeyBytes() {
        return this.privateKeyBytes;
    }

    public void setPrivateKeyBytes(byte[] privateKeyBytes) {
        this.privateKeyBytes = privateKeyBytes;
    }

    public String getPrivateKeyFilePassphrase() {
        return this.privateKeyFilePassphrase;
    }

    public void setPrivateKeyFilePassphrase(String privateKeyFilePassphrase) {
        this.privateKeyFilePassphrase = privateKeyFilePassphrase;
    }

    public String getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public void setChmod(String chmod) {
        if (chmod.length() == 3) {
            for (byte c : chmod.getBytes()) {
                if (c >= 48 && c <= 55) continue;
                chmod = DEFAULT_MOD;
                break;
            }
        } else {
            chmod = DEFAULT_MOD;
        }
        this.chmod = chmod;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setPreferredAuthentications(String preferredAuthentications) {
        this.preferredAuthentications = preferredAuthentications;
    }

    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }
}

