/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jsh;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptException;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jsh {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jsh.class);
    private static final ThreadLocal<Map<String, Object>> BINDINGS = ThreadLocal.withInitial(ConcurrentHashMap::new);

    private Jsh() {
    }

    public static List<String> compile(JShell jshell, String script) throws ScriptException {
        ArrayList<String> snippets = new ArrayList<String>();
        while (!script.isEmpty()) {
            SourceCodeAnalysis.CompletionInfo ci = jshell.sourceCodeAnalysis().analyzeCompletion(script);
            if (!ci.completeness().isComplete()) {
                throw new ScriptException("Incomplete script:\n" + script);
            }
            snippets.add(ci.source());
            script = ci.remaining();
        }
        return snippets;
    }

    public static void setBinding(JShell jshell, String name, Object value) throws ScriptException {
        ObjectHelper.notNull((Object)jshell, (String)"jshell");
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull((Object)value, (String)"value");
        Jsh.setBinding(jshell, name, value, value.getClass());
    }

    public static <T> void setBinding(JShell jshell, String name, T value, Class<? extends T> type) throws ScriptException {
        ObjectHelper.notNull((Object)jshell, (String)"jshell");
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull(value, (String)"value");
        ObjectHelper.notNull(type, (String)"type");
        Jsh.setBinding(name, value);
        String snippet = String.format("var %s = %s.getBinding(\"%s\", %s.class);", name, Jsh.class.getName(), name, type.getName());
        Jsh.eval(jshell, snippet);
    }

    public static Object getBinding(String name) {
        return BINDINGS.get().get(name);
    }

    public static <T> T getBinding(String name, Class<T> type) {
        Object answer = BINDINGS.get().get(name);
        return answer != null ? (T)type.cast(answer) : null;
    }

    public static void setBinding(String name, Object value) {
        BINDINGS.get().put(name, value);
    }

    public static void clearBindings() {
        BINDINGS.get().clear();
    }

    public static void eval(JShell jshell, String snippet) throws ScriptException {
        LOGGER.debug("Evaluating {}", (Object)snippet);
        List<SnippetEvent> events = jshell.eval(snippet);
        for (SnippetEvent event : events) {
            if (event.exception() != null) {
                throw new ScriptException(event.exception());
            }
            if (event.status() == Snippet.Status.VALID) continue;
            throw new ScriptException("Error evaluating snippet:\n" + event.snippet().source());
        }
    }

    public static ExecutionControlProvider wrapExecutionControl(final String name, final ExecutionControl delegate) {
        return new ExecutionControlProvider(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public ExecutionControl generate(ExecutionEnv env, Map<String, String> parameters) throws Throwable {
                return delegate;
            }
        };
    }
}

