/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jsh;

import java.util.HashMap;
import java.util.Map;
import jdk.jshell.spi.ExecutionControl;

final class JshClassLoader
extends ClassLoader {
    private final Map<String, ExecutionControl.ClassBytecodes> types = new HashMap<String, ExecutionControl.ClassBytecodes>();

    JshClassLoader(ClassLoader parent) {
        super(parent);
    }

    void addClassBytecodes(ExecutionControl.ClassBytecodes classBytecodes) {
        this.types.put(JshClassLoader.toResourceString(classBytecodes.name()), classBytecodes);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String key = JshClassLoader.toResourceString(name);
        ExecutionControl.ClassBytecodes cb = this.types.get(key);
        return cb == null ? super.findClass(name) : super.defineClass(name, cb.bytecodes(), 0, cb.bytecodes().length);
    }

    private static String toResourceString(String name) {
        return name.replace('.', '/') + ".class";
    }
}

