/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jsh;

import java.util.HashMap;
import java.util.Map;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;
import org.apache.camel.dsl.jsh.JshClassLoader;

final class JshLoaderDelegate
implements LoaderDelegate {
    private final JshClassLoader loader;
    private final Map<String, Class<?>> types;

    public JshLoaderDelegate(JshClassLoader loader) {
        this.loader = loader;
        this.types = new HashMap();
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbs) throws ExecutionControl.ClassInstallException, ExecutionControl.EngineTerminationException {
        boolean[] loaded = new boolean[cbs.length];
        try {
            for (ExecutionControl.ClassBytecodes cb : cbs) {
                this.loader.addClassBytecodes(cb);
            }
            for (int i = 0; i < cbs.length; ++i) {
                Class<?> type = this.loader.loadClass(cbs[i].name());
                type.getDeclaredMethods();
                this.types.put(cbs[i].name(), type);
                loaded[i] = true;
            }
        }
        catch (Throwable ex) {
            throw new ExecutionControl.ClassInstallException("load: " + ex.getMessage(), loaded);
        }
    }

    @Override
    public void classesRedefined(ExecutionControl.ClassBytecodes[] cbcs) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void addToClasspath(String cp) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> type = this.types.get(name);
        if (type != null) {
            return type;
        }
        throw new ClassNotFoundException(name + " not found");
    }
}

