/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jsh;

import java.io.Reader;
import javax.script.ScriptException;
import jdk.jshell.JShell;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import org.apache.camel.CamelContext;
import org.apache.camel.Experimental;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.dsl.jsh.Jsh;
import org.apache.camel.dsl.jsh.JshClassLoader;
import org.apache.camel.dsl.jsh.JshLoaderDelegate;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.RoutesBuilderLoaderSupport;
import org.apache.camel.util.IOHelper;

@ManagedResource(description="Managed JShell RoutesBuilderLoader")
@Experimental
@RoutesLoader(value="jsh")
public class JshRoutesBuilderLoader
extends RoutesBuilderLoaderSupport {
    public static final String EXTENSION = "jsh";

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return EXTENSION;
    }

    public RoutesBuilder loadRoutesBuilder(Resource resource) throws Exception {
        return EndpointRouteBuilder.loadEndpointRoutesBuilder((Resource)resource, JshRoutesBuilderLoader::eval);
    }

    private static void eval(Reader reader, EndpointRouteBuilder builder) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String content = IOHelper.toString((Reader)reader);
        JshClassLoader jshcl = new JshClassLoader(tccl);
        JshLoaderDelegate delegate = new JshLoaderDelegate(jshcl);
        DirectExecutionControl control = new DirectExecutionControl(delegate);
        ExecutionControlProvider provider = Jsh.wrapExecutionControl("jsh-direct", control);
        Thread.currentThread().setContextClassLoader(jshcl);
        try (JShell jshell = JShell.builder().executionEngine(provider, null).build();){
            Jsh.setBinding(jshell, "builder", builder, EndpointRouteBuilder.class);
            Jsh.setBinding(jshell, "context", builder.getContext(), CamelContext.class);
            Jsh.setBinding(jshell, "registry", builder.getContext().getRegistry(), Registry.class);
            for (String snippet : Jsh.compile(jshell, content)) {
                Jsh.eval(jshell, snippet);
            }
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        finally {
            Jsh.clearBindings();
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

