/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonvalidator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import java.io.InputStream;
import java.net.URI;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jsonvalidator.JsonUriSchemaLoader;
import org.apache.camel.support.ResourceHelper;

public class DefaultJsonUriSchemaLoader
implements JsonUriSchemaLoader {
    protected ObjectMapper mapper = new ObjectMapper();
    protected SchemaValidatorsConfig config = new SchemaValidatorsConfig();
    protected SpecVersion.VersionFlag defaultVersion = SpecVersion.VersionFlag.V201909;

    @Override
    public JsonSchema createSchema(CamelContext camelContext, String schemaUri) throws Exception {
        SpecVersion.VersionFlag version;
        InputStream stream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)schemaUri);
        JsonNode node = this.mapper.readTree(stream);
        try {
            version = SpecVersionDetector.detect((JsonNode)node);
        }
        catch (JsonSchemaException e) {
            version = this.defaultVersion;
        }
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)version);
        URI uri = ResourceHelper.hasScheme((String)schemaUri) ? URI.create(schemaUri) : URI.create("classpath:" + schemaUri);
        return factory.getSchema(uri, this.config);
    }
}

