/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonvalidator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import java.io.InputStream;
import java.util.Set;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.StreamCache;
import org.apache.camel.ValidationException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jsonvalidator.DefaultJsonSchemaLoader;
import org.apache.camel.component.jsonvalidator.DefaultJsonValidationErrorHandler;
import org.apache.camel.component.jsonvalidator.JsonSchemaLoader;
import org.apache.camel.component.jsonvalidator.JsonValidatorErrorHandler;
import org.apache.camel.component.jsonvalidator.NoJsonBodyValidationException;
import org.apache.camel.component.jsonvalidator.NoJsonHeaderValidationException;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@ManagedResource(description="Managed JsonValidatorEndpoint")
@UriEndpoint(scheme="json-validator", firstVersion="2.20.0", title="JSON Schema Validator", syntax="json-validator:resourceUri", producerOnly=true, category={Category.VALIDATION})
public class JsonValidatorEndpoint
extends ResourceEndpoint {
    private volatile JsonSchema schema;
    @UriParam(defaultValue="true")
    private boolean failOnNullBody = true;
    @UriParam(defaultValue="true")
    private boolean failOnNullHeader = true;
    @UriParam(description="To validate against a header instead of the message body.")
    private String headerName;
    @UriParam(label="advanced")
    private JsonValidatorErrorHandler errorHandler = new DefaultJsonValidationErrorHandler();
    @UriParam(label="advanced")
    private JsonSchemaLoader schemaLoader = new DefaultJsonSchemaLoader();

    public JsonValidatorEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    public void clearContentCache() {
        this.schema = null;
        super.clearContentCache();
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExchange(Exchange exchange) throws Exception {
        JsonSchema localSchema;
        StreamCache cache = null;
        Object content = this.getContentToValidate(exchange);
        if (!(content instanceof StreamCache) && content instanceof InputStream && (cache = (StreamCache)exchange.getContext().getTypeConverter().convertTo(StreamCache.class, exchange, content)) != null) {
            if (this.shouldUseHeader()) {
                exchange.getIn().setHeader(this.headerName, (Object)cache);
            } else {
                exchange.getIn().setBody((Object)cache);
            }
        }
        if ((localSchema = this.schema) == null) {
            localSchema = this.getOrCreateSchema();
        }
        try {
            if (this.shouldUseHeader()) {
                if (content == null && this.isFailOnNullHeader()) {
                    throw new NoJsonHeaderValidationException(exchange, this.headerName);
                }
            } else if (content == null && this.isFailOnNullBody()) {
                throw new NoJsonBodyValidationException(exchange);
            }
            if (content != null) {
                InputStream is;
                ObjectMapper mapper;
                JsonNode node;
                if (cache == null) {
                    cache = (StreamCache)exchange.getContext().getTypeConverter().convertTo(StreamCache.class, exchange, content);
                }
                if ((node = (mapper = new ObjectMapper()).readTree(is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, cache != null ? cache : content))) == null) {
                    throw new NoJsonBodyValidationException(exchange);
                }
                Set errors = localSchema.validate(node);
                if (!errors.isEmpty()) {
                    this.log.debug("Validated JSON has {} errors", (Object)errors.size());
                    this.errorHandler.handleErrors(exchange, this.schema, errors);
                } else {
                    this.log.debug("Validated JSON success");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw e;
            }
            this.errorHandler.handleErrors(exchange, this.schema, e);
        }
        finally {
            if (cache != null) {
                cache.reset();
            }
        }
    }

    private Object getContentToValidate(Exchange exchange) {
        if (this.shouldUseHeader()) {
            return exchange.getIn().getHeader(this.headerName);
        }
        return exchange.getIn().getBody();
    }

    private boolean shouldUseHeader() {
        return this.headerName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonSchema getOrCreateSchema() throws Exception {
        JsonValidatorEndpoint jsonValidatorEndpoint = this;
        synchronized (jsonValidatorEndpoint) {
            if (this.schema == null) {
                this.schema = this.schemaLoader.createSchema(this.getCamelContext(), this.getResourceAsInputStream());
            }
        }
        return this.schema;
    }

    protected String createEndpointUri() {
        return "json-validator:" + this.getResourceUri();
    }

    public JsonValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(JsonValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public JsonSchemaLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    public void setSchemaLoader(JsonSchemaLoader schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    public boolean isFailOnNullHeader() {
        return this.failOnNullHeader;
    }

    public void setFailOnNullHeader(boolean failOnNullHeader) {
        this.failOnNullHeader = failOnNullHeader;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

