/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonapi;

import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.ResourceConverter;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="jsonApi")
public class JsonApiDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private Class<?>[] dataFormatTypes;
    private Class<?> mainFormatType;

    public JsonApiDataFormat() {
    }

    public JsonApiDataFormat(Class<?>[] dataFormatTypes) {
        this.dataFormatTypes = dataFormatTypes;
    }

    public JsonApiDataFormat(Class<?> mainFormatType, Class<?>[] dataFormatTypes) {
        this.mainFormatType = mainFormatType;
        this.dataFormatTypes = dataFormatTypes;
    }

    public String getDataFormatName() {
        return "jsonApi";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ResourceConverter converter = new ResourceConverter((Class[])this.dataFormatTypes);
        byte[] objectAsBytes = converter.writeDocument(new JSONAPIDocument(graph));
        stream.write(objectAsBytes);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        ResourceConverter converter = new ResourceConverter((Class[])this.dataFormatTypes);
        JSONAPIDocument jsonApiDocument = converter.readDocument(stream, this.mainFormatType);
        return jsonApiDocument.get();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public void setDataFormatTypes(Class<?>[] dataFormatTypes) {
        this.dataFormatTypes = dataFormatTypes;
    }

    public void setMainFormatType(Class<?> mainFormatType) {
        this.mainFormatType = mainFormatType;
    }
}

