/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConverter;

public class JsonPathEngine {
    private final JsonPath path;
    private final Configuration configuration = Configuration.defaultConfiguration();

    public JsonPathEngine(String expression) {
        this.path = JsonPath.compile((String)expression, (Filter[])new Filter[0]);
    }

    public Object read(Exchange exchange) throws IOException, InvalidPayloadException {
        Object json = exchange.getIn().getBody();
        if (json instanceof GenericFile) {
            try {
                json = GenericFileConverter.genericFileToInputStream((GenericFile)((GenericFile)json), (Exchange)exchange);
            }
            catch (NoTypeConversionAvailableException e) {
                json = ((WrappedFile)json).getFile();
            }
        } else if (json instanceof WrappedFile) {
            json = ((WrappedFile)json).getFile();
        }
        if (this.configuration.getProvider().isContainer(json)) {
            return this.path.read(json);
        }
        if (json instanceof String) {
            String str = (String)json;
            return this.path.read(str);
        }
        if (json instanceof InputStream) {
            InputStream is = (InputStream)json;
            return this.path.read(is);
        }
        if (json instanceof File) {
            File file = (File)json;
            return this.path.read(file);
        }
        if (json instanceof URL) {
            URL url = (URL)json;
            return this.path.read(url);
        }
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        return this.path.read(is);
    }
}

