/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.DefaultsImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.jsonpath.JsonStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathEngine.class);
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("\\$\\{[^\\}]+\\}", 8);
    private final String expression;
    private final JsonPath path;
    private final Configuration configuration;

    public JsonPathEngine(String expression) {
        this(expression, false, true, null);
    }

    public JsonPathEngine(String expression, boolean suppressExceptions, boolean allowSimple, Option[] options) {
        Matcher matcher;
        Configuration.ConfigurationBuilder builder;
        this.expression = expression;
        DefaultsImpl defaults = DefaultsImpl.INSTANCE;
        if (options != null) {
            builder = Configuration.builder().jsonProvider(defaults.jsonProvider()).options(options);
            if (suppressExceptions) {
                builder.options(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            }
            this.configuration = builder.build();
        } else {
            builder = Configuration.builder().jsonProvider(defaults.jsonProvider());
            if (suppressExceptions) {
                builder.options(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            }
            this.configuration = builder.build();
        }
        boolean hasSimple = false;
        if (allowSimple && (matcher = SIMPLE_PATTERN.matcher(expression)).find()) {
            hasSimple = true;
        }
        if (hasSimple) {
            this.path = null;
        } else {
            this.path = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
            LOG.debug("Compiled static JsonPath: {}", (Object)expression);
        }
    }

    public Object read(Exchange exchange) throws IOException, InvalidPayloadException {
        if (this.path == null) {
            Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(this.expression);
            String text = (String)exp.evaluate(exchange, String.class);
            JsonPath path = JsonPath.compile((String)text, (Predicate[])new Predicate[0]);
            LOG.debug("Compiled dynamic JsonPath: {}", (Object)this.expression);
            return this.doRead(path, exchange);
        }
        return this.doRead(this.path, exchange);
    }

    private Object doRead(JsonPath path, Exchange exchange) throws IOException, InvalidPayloadException {
        GenericFile genericFile;
        Object json = exchange.getIn().getBody();
        if (json instanceof GenericFile && (genericFile = (GenericFile)json).getCharset() != null) {
            FileInputStream inputStream = new FileInputStream((File)genericFile.getFile());
            return path.read((InputStream)inputStream, genericFile.getCharset(), this.configuration);
        }
        if (json instanceof String) {
            String str = (String)json;
            return path.read(str, this.configuration);
        }
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        String jsonEncoding = (String)exchange.getIn().getHeader("CamelJsonPathJsonEncoding", String.class);
        if (jsonEncoding != null) {
            return path.read(is, jsonEncoding, this.configuration);
        }
        JsonStream jsonStream = new JsonStream(is);
        return path.read((InputStream)jsonStream, jsonStream.getEncoding().name(), this.configuration);
    }
}

