/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.jsonpath.JsonPathExpression;
import org.apache.camel.jsonpath.easypredicate.EasyPredicateParser;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="jsonpath")
public class JsonPathLanguage
extends LanguageSupport
implements PropertyConfigurer {
    private Class<?> resultType;
    private boolean suppressExceptions;
    private boolean allowSimple = true;
    private boolean allowEasyPredicate = true;
    private boolean writeAsString;
    private String headerName;
    private Option[] options;

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public boolean isAllowSimple() {
        return this.allowSimple;
    }

    public void setAllowSimple(boolean allowSimple) {
        this.allowSimple = allowSimple;
    }

    public boolean isAllowEasyPredicate() {
        return this.allowEasyPredicate;
    }

    public void setAllowEasyPredicate(boolean allowEasyPredicate) {
        this.allowEasyPredicate = allowEasyPredicate;
    }

    public boolean isWriteAsString() {
        return this.writeAsString;
    }

    public void setWriteAsString(boolean writeAsString) {
        this.writeAsString = writeAsString;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option ... options) {
        this.options = options;
    }

    public Predicate createPredicate(String expression) {
        JsonPathExpression answer = (JsonPathExpression)this.createExpression(expression);
        answer.setPredicate(true);
        return answer;
    }

    public Expression createExpression(String expression) {
        JsonPathExpression answer = new JsonPathExpression(expression);
        answer.setResultType(this.resultType);
        answer.setSuppressExceptions(this.suppressExceptions);
        answer.setAllowSimple(this.allowSimple);
        answer.setAllowEasyPredicate(this.allowEasyPredicate);
        answer.setHeaderName(this.headerName);
        answer.setWriteAsString(this.writeAsString);
        answer.setHeaderName(this.headerName);
        answer.setOptions(this.options);
        answer.init(this.getCamelContext());
        return answer;
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        JsonPathExpression json = (JsonPathExpression)this.createExpression(expression, properties);
        json.setPredicate(true);
        return json;
    }

    public Expression createExpression(String expression, Object[] properties) {
        JsonPathExpression answer = new JsonPathExpression(expression);
        answer.setResultType((Class)this.property(Class.class, properties, 0, this.resultType));
        answer.setSuppressExceptions((Boolean)this.property(Boolean.TYPE, properties, 1, this.suppressExceptions));
        answer.setAllowSimple((Boolean)this.property(Boolean.TYPE, properties, 2, this.allowSimple));
        answer.setAllowEasyPredicate((Boolean)this.property(Boolean.TYPE, properties, 3, this.allowEasyPredicate));
        answer.setWriteAsString((Boolean)this.property(Boolean.TYPE, properties, 4, this.writeAsString));
        answer.setHeaderName((String)this.property(String.class, properties, 5, this.headerName));
        String option = (String)properties[6];
        if (option != null) {
            ArrayList<Option> list = new ArrayList<Option>();
            for (String s : option.split(",")) {
                list.add((Option)this.getCamelContext().getTypeConverter().convertTo(Option.class, (Object)s));
            }
            answer.setOptions(list.toArray(new Option[list.size()]));
        }
        answer.init(this.getCamelContext());
        return answer;
    }

    public boolean validateExpression(String expression) {
        JsonPath.compile((String)expression, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        return true;
    }

    public boolean validatePredicate(String expression) {
        EasyPredicateParser parser = new EasyPredicateParser();
        String exp = parser.parse(expression);
        JsonPath.compile((String)exp, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        return true;
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resulttype": 
            case "resultType": {
                this.setResultType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "suppressexceptions": 
            case "suppressExceptions": {
                this.setSuppressExceptions((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowsimple": 
            case "allowSimple": {
                this.setAllowSimple((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "alloweasypredicate": 
            case "allowEasyPredicate": {
                this.setAllowEasyPredicate((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "headername": 
            case "headerName": {
                this.setHeaderName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "writeasstring": 
            case "writeAsString": {
                this.setWriteAsString((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "options": {
                this.setOptions((Option[])PropertyConfigurerSupport.property((CamelContext)camelContext, Option[].class, (Object)value));
                return true;
            }
        }
        return false;
    }
}

