/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.component.jt400.Jt400PgmCallException;
import org.apache.camel.component.jt400.Jt400Type;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400PgmProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400PgmProducer.class);

    public Jt400PgmProducer(Jt400Endpoint endpoint) {
        super((Endpoint)endpoint);
    }

    private Jt400Endpoint getISeriesEndpoint() {
        return (Jt400Endpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        block10: {
            AS400 iSeries = null;
            try {
                ProgramCall pgmCall;
                iSeries = this.connect();
                String commandStr = this.getISeriesEndpoint().getObjectPath();
                ProgramParameter[] parameterList = this.getParameterList(exchange, iSeries);
                if (this.getISeriesEndpoint().getType() == Jt400Type.PGM) {
                    pgmCall = new ProgramCall(iSeries);
                } else {
                    pgmCall = new ServiceProgramCall(iSeries);
                    ((ServiceProgramCall)pgmCall).setProcedureName(this.getISeriesEndpoint().getProcedureName());
                    ((ServiceProgramCall)pgmCall).setReturnValueFormat(0);
                }
                pgmCall.setProgram(commandStr);
                pgmCall.setParameterList(parameterList);
                if (LOG.isDebugEnabled()) {
                    LOG.trace("Starting to call PGM '{}' in host '{}' authentication with the user '{}'", new Object[]{commandStr, iSeries.getSystemName(), iSeries.getUserId()});
                }
                boolean result = pgmCall.run();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Executed PGM '{}' in host '{}'. Success? {}", new Object[]{commandStr, iSeries.getSystemName(), result});
                }
                if (result) {
                    this.handlePGMOutput(exchange, pgmCall, parameterList, iSeries);
                    break block10;
                }
                throw new Jt400PgmCallException(this.getOutputMessages(pgmCall));
            }
            catch (Exception e) {
                throw new Jt400PgmCallException(e);
            }
            finally {
                this.release(iSeries);
            }
        }
    }

    private ProgramParameter[] getParameterList(Exchange exchange, AS400 iSeries) throws InvalidPayloadException, PropertyVetoException {
        Object body = exchange.getIn().getMandatoryBody();
        Object[] params = (Object[])body;
        ProgramParameter[] parameterList = new ProgramParameter[params.length];
        for (int i = 0; i < params.length; ++i) {
            boolean input;
            boolean output;
            Object param = params[i];
            if (this.getISeriesEndpoint().isFieldIdxForOuput(i)) {
                output = true;
                input = param != null;
            } else {
                output = false;
                input = true;
            }
            byte[] inputData = null;
            int length = this.getISeriesEndpoint().getOutputFieldLength(i);
            if (input && param != null) {
                AS400Text typeConverter;
                if (param instanceof CharSequence) {
                    param = param.toString();
                    typeConverter = new AS400Text(length, iSeries);
                } else if (param instanceof char[]) {
                    param = new String((char[])param);
                    typeConverter = new AS400Text(length, iSeries);
                } else if (param instanceof Integer) {
                    typeConverter = new AS400Bin4();
                } else if (param instanceof Long) {
                    typeConverter = new AS400Bin8();
                } else if (param instanceof byte[]) {
                    typeConverter = new AS400ByteArray(length);
                } else {
                    param = param.toString();
                    typeConverter = new AS400Text(length, iSeries);
                }
                inputData = typeConverter.toBytes(param);
            }
            if (input && output) {
                LOG.trace("Parameter {} is both input and output.", (Object)i);
                if (this.getISeriesEndpoint().getType() == Jt400Type.PGM) {
                    parameterList[i] = new ProgramParameter(inputData, length);
                    continue;
                }
                parameterList[i] = new ProgramParameter(2, inputData, length);
                continue;
            }
            if (input) {
                LOG.trace("Parameter {} is input.", (Object)i);
                if (inputData != null) {
                    parameterList[i] = new ProgramParameter(inputData);
                    continue;
                }
                parameterList[i] = new ProgramParameter();
                parameterList[i].setParameterType(2);
                parameterList[i].setNullParameter(true);
                continue;
            }
            LOG.trace("Parameter {} is output.", (Object)i);
            parameterList[i] = new ProgramParameter(length);
        }
        return parameterList;
    }

    private void handlePGMOutput(Exchange exchange, ProgramCall pgmCall, ProgramParameter[] inputs, AS400 iSeries) throws InvalidPayloadException {
        Object body = exchange.getIn().getMandatoryBody();
        Object[] params = (Object[])body;
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 1;
        for (ProgramParameter pgmParam : pgmCall.getParameterList()) {
            byte[] output = pgmParam.getOutputData();
            Object javaValue = params[i - 1];
            if (output != null) {
                int length = pgmParam.getOutputDataLength();
                Object typeConverter = this.getISeriesEndpoint().getFormat() == Jt400Configuration.Format.binary ? new AS400ByteArray(length) : new AS400Text(length, iSeries);
                javaValue = typeConverter.toObject(output);
            }
            results.add(javaValue);
            ++i;
        }
        Object[] bodyOUT = new Object[results.size()];
        bodyOUT = results.toArray(bodyOUT);
        exchange.getOut().setBody((Object)bodyOUT);
    }

    private String getOutputMessages(ProgramCall pgmCall) throws Exception {
        StringBuilder outputMsg = new StringBuilder();
        AS400Message[] messageList = pgmCall.getMessageList();
        for (int i = 0; i < messageList.length; ++i) {
            messageList[i].load();
            outputMsg.append(i + ") ");
            outputMsg.append(messageList[i].getText());
            outputMsg.append(" - ");
            outputMsg.append(messageList[i].getHelp());
            outputMsg.append("\n");
        }
        return outputMsg.toString();
    }

    private AS400 connect() throws Exception {
        AS400 iSeries = this.getISeriesEndpoint().getSystem();
        if (!iSeries.isConnected(2)) {
            LOG.debug("Connecting to {}", (Object)this.getISeriesEndpoint());
            iSeries.connectService(2);
        }
        return iSeries;
    }

    private void release(AS400 iSeries) {
        if (iSeries != null) {
            LOG.debug("Releasing connection to {}", (Object)this.getISeriesEndpoint());
            this.getISeriesEndpoint().releaseSystem(iSeries);
        }
    }
}

