/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class KafkaEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return KafkaEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return KafkaEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "brokers": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setBrokers((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientId": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setClientId((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "headerFilterStrategy": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setHeaderFilterStrategy((HeaderFilterStrategy)KafkaEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "topicIsPattern": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setTopicIsPattern((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "groupId": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setGroupId((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerStreams": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConsumerStreams((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumersCount": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConsumersCount((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "kafkaHeaderDeserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKafkaHeaderDeserializer((KafkaHeaderDeserializer)KafkaEndpointConfigurer.property((CamelContext)camelContext, KafkaHeaderDeserializer.class, (Object)value));
                return true;
            }
            case "interceptorClasses": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setInterceptorClasses((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyDeserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKeyDeserializer((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "valueDeserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setValueDeserializer((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "fetchMinBytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setFetchMinBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "fetchMaxBytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setFetchMaxBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "heartbeatIntervalMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setHeartbeatIntervalMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxPartitionFetchBytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxPartitionFetchBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sessionTimeoutMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSessionTimeoutMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxPollRecords": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxPollRecords((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "pollTimeoutMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPollTimeoutMs((Long)KafkaEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "maxPollIntervalMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxPollIntervalMs((Long)KafkaEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "autoOffsetReset": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoOffsetReset((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "partitionAssignor": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPartitionAssignor((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerRequestTimeoutMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConsumerRequestTimeoutMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "autoCommitIntervalMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoCommitIntervalMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "checkCrcs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setCheckCrcs((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "fetchWaitMaxMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setFetchWaitMaxMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "seekTo": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSeekTo((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autoCommitEnable": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoCommitEnable((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "allowManualCommit": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAllowManualCommit((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoCommitOnStop": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoCommitOnStop((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "breakOnFirstError": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setBreakOnFirstError((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "offsetRepository": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setOffsetRepository((StateRepository<String, String>)((StateRepository)KafkaEndpointConfigurer.property((CamelContext)camelContext, StateRepository.class, (Object)value)));
                return true;
            }
            case "partitioner": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPartitioner((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "retryBackoffMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRetryBackoffMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "workerPool": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setWorkerPool((ExecutorService)KafkaEndpointConfigurer.property((CamelContext)camelContext, ExecutorService.class, (Object)value));
                return true;
            }
            case "workerPoolCoreSize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setWorkerPoolCoreSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "workerPoolMaxSize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setWorkerPoolMaxSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "queueBufferingMaxMessages": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setQueueBufferingMaxMessages((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "serializerClass": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSerializerClass((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keySerializerClass": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKeySerializerClass((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "key": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKey((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "partitionKey": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPartitionKey((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "requestRequiredAcks": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRequestRequiredAcks((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bufferMemorySize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setBufferMemorySize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "compressionCodec": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setCompressionCodec((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "retries": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRetries((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "producerBatchSize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setProducerBatchSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "connectionMaxIdleMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConnectionMaxIdleMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "lingerMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setLingerMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxBlockMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxBlockMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxRequestSize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxRequestSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "receiveBufferBytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setReceiveBufferBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "requestTimeoutMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRequestTimeoutMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sendBufferBytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSendBufferBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "recordMetadata": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRecordMetadata((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxInFlightRequest": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxInFlightRequest((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metadataMaxAgeMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMetadataMaxAgeMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metricReporters": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMetricReporters((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noOfMetricsSample": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setNoOfMetricsSample((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metricsSampleWindowMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMetricsSampleWindowMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "reconnectBackoffMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setReconnectBackoffMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "enableIdempotence": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setEnableIdempotence((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kafkaHeaderSerializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKafkaHeaderSerializer((KafkaHeaderSerializer)KafkaEndpointConfigurer.property((CamelContext)camelContext, KafkaHeaderSerializer.class, (Object)value));
                return true;
            }
            case "reconnectBackoffMaxMs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setReconnectBackoffMaxMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sslContextParameters": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslContextParameters((SSLContextParameters)KafkaEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "sslKeyPassword": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeyPassword((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslKeystoreLocation": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeystoreLocation((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslKeystorePassword": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeystorePassword((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslTruststoreLocation": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTruststoreLocation((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslTruststorePassword": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTruststorePassword((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslEnabledProtocols": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslEnabledProtocols((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslKeystoreType": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeystoreType((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslProtocol": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslProtocol((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslProvider": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslProvider((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslTruststoreType": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTruststoreType((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslCipherSuites": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslCipherSuites((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslEndpointAlgorithm": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslEndpointAlgorithm((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslKeymanagerAlgorithm": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeymanagerAlgorithm((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslTrustmanagerAlgorithm": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTrustmanagerAlgorithm((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslKerberosServiceName": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSaslKerberosServiceName((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securityProtocol": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSecurityProtocol((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslMechanism": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSaslMechanism((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosInitCmd": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosInitCmd((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosBeforeReloginMinTime": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosBeforeReloginMinTime((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "kerberosRenewJitter": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosRenewJitter((Double)KafkaEndpointConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "kerberosRenewWindowFactor": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosRenewWindowFactor((Double)KafkaEndpointConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "kerberosPrincipalToLocalRules": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosPrincipalToLocalRules((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslJaasConfig": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSaslJaasConfig((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schemaRegistryURL": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSchemaRegistryURL((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "specificAvroReader": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSpecificAvroReader((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((KafkaEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((KafkaEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((KafkaEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KafkaEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((KafkaEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KafkaEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KafkaEndpoint)((Object)endpoint)).setSynchronous((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((KafkaEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "brokers": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setBrokers((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientid": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setClientId((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "headerfilterstrategy": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setHeaderFilterStrategy((HeaderFilterStrategy)KafkaEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "topicispattern": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setTopicIsPattern((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "groupid": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setGroupId((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerstreams": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConsumerStreams((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumerscount": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConsumersCount((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "kafkaheaderdeserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKafkaHeaderDeserializer((KafkaHeaderDeserializer)KafkaEndpointConfigurer.property((CamelContext)camelContext, KafkaHeaderDeserializer.class, (Object)value));
                return true;
            }
            case "interceptorclasses": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setInterceptorClasses((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keydeserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKeyDeserializer((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "valuedeserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setValueDeserializer((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "fetchminbytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setFetchMinBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "fetchmaxbytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setFetchMaxBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "heartbeatintervalms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setHeartbeatIntervalMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxpartitionfetchbytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxPartitionFetchBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sessiontimeoutms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSessionTimeoutMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxpollrecords": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxPollRecords((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "polltimeoutms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPollTimeoutMs((Long)KafkaEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "maxpollintervalms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxPollIntervalMs((Long)KafkaEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "autooffsetreset": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoOffsetReset((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "partitionassignor": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPartitionAssignor((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerrequesttimeoutms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConsumerRequestTimeoutMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "autocommitintervalms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoCommitIntervalMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "checkcrcs": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setCheckCrcs((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "fetchwaitmaxms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setFetchWaitMaxMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "seekto": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSeekTo((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autocommitenable": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoCommitEnable((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "allowmanualcommit": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAllowManualCommit((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autocommitonstop": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setAutoCommitOnStop((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "breakonfirsterror": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setBreakOnFirstError((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "offsetrepository": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setOffsetRepository((StateRepository<String, String>)((StateRepository)KafkaEndpointConfigurer.property((CamelContext)camelContext, StateRepository.class, (Object)value)));
                return true;
            }
            case "partitioner": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPartitioner((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "retrybackoffms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRetryBackoffMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "workerpool": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setWorkerPool((ExecutorService)KafkaEndpointConfigurer.property((CamelContext)camelContext, ExecutorService.class, (Object)value));
                return true;
            }
            case "workerpoolcoresize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setWorkerPoolCoreSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "workerpoolmaxsize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setWorkerPoolMaxSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "queuebufferingmaxmessages": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setQueueBufferingMaxMessages((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "serializerclass": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSerializerClass((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyserializerclass": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKeySerializerClass((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "key": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKey((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "partitionkey": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setPartitionKey((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "requestrequiredacks": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRequestRequiredAcks((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "buffermemorysize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setBufferMemorySize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "compressioncodec": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setCompressionCodec((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "retries": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRetries((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "producerbatchsize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setProducerBatchSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "connectionmaxidlems": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setConnectionMaxIdleMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "lingerms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setLingerMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxblockms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxBlockMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxrequestsize": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxRequestSize((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "receivebufferbytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setReceiveBufferBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "requesttimeoutms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRequestTimeoutMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sendbufferbytes": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSendBufferBytes((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "recordmetadata": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setRecordMetadata((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxinflightrequest": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMaxInFlightRequest((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metadatamaxagems": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMetadataMaxAgeMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metricreporters": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMetricReporters((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noofmetricssample": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setNoOfMetricsSample((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "metricssamplewindowms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setMetricsSampleWindowMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "reconnectbackoffms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setReconnectBackoffMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "enableidempotence": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setEnableIdempotence((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kafkaheaderserializer": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKafkaHeaderSerializer((KafkaHeaderSerializer)KafkaEndpointConfigurer.property((CamelContext)camelContext, KafkaHeaderSerializer.class, (Object)value));
                return true;
            }
            case "reconnectbackoffmaxms": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setReconnectBackoffMaxMs((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslContextParameters((SSLContextParameters)KafkaEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "sslkeypassword": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeyPassword((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeystorelocation": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeystoreLocation((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeystorepassword": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeystorePassword((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltruststorelocation": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTruststoreLocation((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltruststorepassword": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTruststorePassword((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslenabledprotocols": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslEnabledProtocols((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeystoretype": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeystoreType((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslprotocol": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslProtocol((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslprovider": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslProvider((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltruststoretype": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTruststoreType((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslciphersuites": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslCipherSuites((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslendpointalgorithm": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslEndpointAlgorithm((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslkeymanageralgorithm": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslKeymanagerAlgorithm((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ssltrustmanageralgorithm": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSslTrustmanagerAlgorithm((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslkerberosservicename": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSaslKerberosServiceName((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securityprotocol": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSecurityProtocol((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "saslmechanism": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSaslMechanism((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosinitcmd": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosInitCmd((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosbeforereloginmintime": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosBeforeReloginMinTime((Integer)KafkaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "kerberosrenewjitter": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosRenewJitter((Double)KafkaEndpointConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "kerberosrenewwindowfactor": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosRenewWindowFactor((Double)KafkaEndpointConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "kerberosprincipaltolocalrules": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setKerberosPrincipalToLocalRules((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sasljaasconfig": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSaslJaasConfig((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schemaregistryurl": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSchemaRegistryURL((String)KafkaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "specificavroreader": {
                ((KafkaEndpoint)((Object)endpoint)).getConfiguration().setSpecificAvroReader((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((KafkaEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((KafkaEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((KafkaEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KafkaEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((KafkaEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KafkaEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KafkaEndpoint)((Object)endpoint)).setSynchronous((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((KafkaEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KafkaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

