/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.time.Duration;
import java.util.Collections;
import org.apache.camel.component.kafka.DefaultKafkaManualCommit;
import org.apache.camel.component.kafka.KafkaManualCommit;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaManualSyncCommit
extends DefaultKafkaManualCommit
implements KafkaManualCommit {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaManualSyncCommit.class);

    public DefaultKafkaManualSyncCommit(KafkaConsumer consumer, String topicName, String threadId, StateRepository<String, String> offsetRepository, TopicPartition partition, long recordOffset, long commitTimeout) {
        super(consumer, topicName, threadId, offsetRepository, partition, recordOffset, commitTimeout);
        LOG.debug("Using commit timeout of {}", (Object)commitTimeout);
    }

    @Override
    public void commitSync() {
        this.commit();
    }

    @Override
    public void commit() {
        this.commitOffset(this.getOffsetRepository(), this.getPartition(), this.getRecordOffset());
    }

    protected void commitOffset(StateRepository<String, String> offsetRepository, TopicPartition partition, long recordOffset) {
        if (recordOffset != -1L) {
            if (offsetRepository != null) {
                offsetRepository.setState((Object)this.serializeOffsetKey(partition), (Object)this.serializeOffsetValue(recordOffset));
            } else {
                LOG.debug("CommitSync {} from topic {} with offset: {}", new Object[]{this.getThreadId(), this.getTopicName(), recordOffset});
                this.getConsumer().commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(recordOffset + 1L)), Duration.ofMillis(this.getCommitTimeout()));
                LOG.debug("CommitSync done for {} from topic {} with offset: {}", new Object[]{this.getThreadId(), this.getTopicName(), recordOffset});
            }
        }
    }
}

