/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.producer.support.DelegatingCallback;
import org.apache.camel.component.kafka.producer.support.KafkaProducerCallBack;
import org.apache.camel.component.kafka.producer.support.KeyValueHolderIterator;
import org.apache.camel.component.kafka.producer.support.ProducerUtil;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducer.class);
    private org.apache.kafka.clients.producer.KafkaProducer kafkaProducer;
    private final KafkaEndpoint endpoint;
    private ExecutorService workerPool;
    private boolean shutdownWorkerPool;
    private volatile boolean closeKafkaProducer;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        this.endpoint.updateClassProperties(props);
        String brokers = this.endpoint.getKafkaClientFactory().getBrokers(this.endpoint.getConfiguration());
        if (brokers != null) {
            props.put("bootstrap.servers", brokers);
        }
        return props;
    }

    public org.apache.kafka.clients.producer.KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public void setKafkaProducer(org.apache.kafka.clients.producer.KafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        if (this.kafkaProducer == null) {
            this.createProducer(props);
        }
        if (!this.endpoint.getConfiguration().isSynchronous() && this.workerPool == null) {
            this.workerPool = this.endpoint.createProducerExecutor();
            this.shutdownWorkerPool = true;
        }
    }

    private void createProducer(Properties props) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(org.apache.kafka.clients.producer.KafkaProducer.class.getClassLoader());
            LOG.trace("Creating KafkaProducer");
            this.kafkaProducer = this.endpoint.getKafkaClientFactory().getProducer(props);
            this.closeKafkaProducer = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
        LOG.debug("Created KafkaProducer: {}", (Object)this.kafkaProducer);
    }

    protected void doStop() throws Exception {
        if (this.kafkaProducer != null && this.closeKafkaProducer) {
            LOG.debug("Closing KafkaProducer: {}", (Object)this.kafkaProducer);
            this.kafkaProducer.close();
            this.kafkaProducer = null;
        }
        if (this.shutdownWorkerPool && this.workerPool != null) {
            int timeout = this.endpoint.getConfiguration().getShutdownTimeout();
            LOG.debug("Shutting down Kafka producer worker threads with timeout {} millis", (Object)timeout);
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.workerPool, (long)timeout);
            this.workerPool = null;
        }
    }

    protected Iterator<KeyValueHolder<Object, ProducerRecord>> createRecorder(Exchange exchange) throws Exception {
        Object overrideTimeStamp;
        String topic = this.endpoint.getConfiguration().getTopic();
        Long timeStamp = null;
        Object overrideTopic = exchange.getIn().removeHeader("kafka.OVERRIDE_TOPIC");
        if (overrideTopic != null) {
            LOG.debug("Using override topic: {}", overrideTopic);
            topic = overrideTopic.toString();
        }
        if (topic == null) {
            topic = URISupport.extractRemainderPath((URI)new URI(this.endpoint.getEndpointUri()), (boolean)true);
        }
        if ((overrideTimeStamp = exchange.getIn().removeHeader("kafka.OVERRIDE_TIMESTAMP")) instanceof Long) {
            LOG.debug("Using override TimeStamp: {}", overrideTimeStamp);
            timeStamp = (Long)overrideTimeStamp;
        }
        List<Header> propagatedHeaders = this.getPropagatedHeaders(exchange, this.endpoint.getConfiguration());
        Object msg = exchange.getIn().getBody();
        Iterator iterator = null;
        if (msg instanceof Iterable) {
            iterator = ((Iterable)msg).iterator();
        } else if (msg instanceof Iterator) {
            iterator = (Iterator)msg;
        }
        if (iterator != null) {
            Iterator msgList = iterator;
            String msgTopic = topic;
            return new KeyValueHolderIterator(msgList, exchange, this.endpoint.getConfiguration(), msgTopic, propagatedHeaders);
        }
        Integer partitionKey = (Integer)ObjectHelper.supplyIfEmpty((Object)this.endpoint.getConfiguration().getPartitionKey(), () -> (Integer)exchange.getIn().getHeader("kafka.PARTITION_KEY", Integer.class));
        Object key = ObjectHelper.supplyIfEmpty((Object)this.endpoint.getConfiguration().getKey(), () -> exchange.getIn().getHeader("kafka.KEY"));
        if (key != null) {
            key = ProducerUtil.tryConvertToSerializedType(exchange, key, this.endpoint.getConfiguration().getKeySerializer());
        }
        Object value = ProducerUtil.tryConvertToSerializedType(exchange, msg, this.endpoint.getConfiguration().getValueSerializer());
        ProducerRecord record = new ProducerRecord(topic, partitionKey, timeStamp, key, value, propagatedHeaders);
        return Collections.singletonList(new KeyValueHolder((Object)exchange, (Object)record)).iterator();
    }

    private List<Header> getPropagatedHeaders(Exchange exchange, KafkaConfiguration getConfiguration) {
        HeaderFilterStrategy headerFilterStrategy = getConfiguration.getHeaderFilterStrategy();
        KafkaHeaderSerializer headerSerializer = getConfiguration.getHeaderSerializer();
        return exchange.getIn().getHeaders().entrySet().stream().filter(entry -> this.shouldBeFiltered((Map.Entry<String, Object>)entry, exchange, headerFilterStrategy)).map(entry -> this.getRecordHeader((Map.Entry<String, Object>)entry, headerSerializer)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean shouldBeFiltered(Map.Entry<String, Object> entry, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        return !headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange);
    }

    private RecordHeader getRecordHeader(Map.Entry<String, Object> entry, KafkaHeaderSerializer headerSerializer) {
        byte[] headerValue = headerSerializer.serialize(entry.getKey(), entry.getValue());
        if (headerValue == null) {
            return null;
        }
        return new RecordHeader(entry.getKey(), headerValue);
    }

    public void process(Exchange exchange) throws Exception {
        Iterator<KeyValueHolder<Object, ProducerRecord>> c = this.createRecorder(exchange);
        LinkedList<KeyValueHolder> futures = new LinkedList<KeyValueHolder>();
        ArrayList recordMetadatas = new ArrayList();
        if (this.endpoint.getConfiguration().isRecordMetadata()) {
            exchange.getMessage().setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadatas);
        }
        while (c.hasNext()) {
            KeyValueHolder<Object, ProducerRecord> exrec = c.next();
            ProducerRecord rec = (ProducerRecord)exrec.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message to topic: {}, partition: {}, key: {}", new Object[]{rec.topic(), rec.partition(), rec.key()});
            }
            futures.add(new KeyValueHolder(exrec.getKey(), (Object)this.kafkaProducer.send(rec)));
        }
        for (KeyValueHolder f : futures) {
            List metadata = Collections.singletonList(((Future)f.getValue()).get());
            recordMetadatas.addAll(metadata);
            Exchange innerExchange = null;
            if (f.getKey() instanceof Exchange && (innerExchange = (Exchange)f.getKey()) != null && this.endpoint.getConfiguration().isRecordMetadata()) {
                innerExchange.getMessage().setHeader("org.apache.kafka.clients.producer.RecordMetadata", metadata);
            }
            Message innerMessage = null;
            if (!(f.getKey() instanceof Message) || (innerMessage = (Message)f.getKey()) == null || !this.endpoint.getConfiguration().isRecordMetadata()) continue;
            innerMessage.setHeader("org.apache.kafka.clients.producer.RecordMetadata", metadata);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Iterator<KeyValueHolder<Object, ProducerRecord>> c = this.createRecorder(exchange);
            KafkaProducerCallBack cb = new KafkaProducerCallBack(exchange, callback, this.workerPool, this.endpoint.getConfiguration());
            while (c.hasNext()) {
                cb.increment();
                KeyValueHolder<Object, ProducerRecord> exrec = c.next();
                ProducerRecord rec = (ProducerRecord)exrec.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending message to topic: {}, partition: {}, key: {}", new Object[]{rec.topic(), rec.partition(), rec.key()});
                }
                ArrayList<KafkaProducerCallBack> delegates = new ArrayList<KafkaProducerCallBack>(Arrays.asList(cb));
                if (exrec.getKey() != null) {
                    delegates.add(new KafkaProducerCallBack(exrec.getKey(), this.workerPool, this.endpoint.getConfiguration()));
                }
                this.kafkaProducer.send(rec, (Callback)new DelegatingCallback(delegates.toArray(new Callback[0])));
            }
            return cb.allSent();
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
            callback.done(true);
            return true;
        }
    }
}

