/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerCallBack
implements Callback {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducerCallBack.class);
    private final Object body;
    private final AsyncCallback callback;
    private final AtomicInteger count = new AtomicInteger(1);
    private final List<RecordMetadata> recordMetadatas = new ArrayList<RecordMetadata>();
    private final ExecutorService workerPool;

    public KafkaProducerCallBack(Object body, ExecutorService workerPool, KafkaConfiguration configuration) {
        this(body, null, workerPool, configuration);
    }

    public KafkaProducerCallBack(Object body, AsyncCallback callback, ExecutorService workerPool, KafkaConfiguration configuration) {
        this.body = body;
        this.callback = callback;
        this.workerPool = Objects.requireNonNull(workerPool, "A worker pool must be provided");
        if (configuration.isRecordMetadata()) {
            if (body instanceof Exchange) {
                Exchange ex = (Exchange)body;
                ex.getMessage().setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
            }
            if (body instanceof Message) {
                Message msg = (Message)body;
                msg.setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
            }
        }
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public boolean allSent() {
        if (this.count.decrementAndGet() == 0) {
            LOG.trace("All messages sent, continue routing.");
            if (this.callback != null) {
                this.callback.done(true);
            }
            return true;
        }
        return false;
    }

    public void onCompletion(RecordMetadata recordMetadata, Exception e) {
        if (e != null) {
            if (this.body instanceof Exchange) {
                ((Exchange)this.body).setException((Throwable)e);
            }
            if (this.body instanceof Message && ((Message)this.body).getExchange() != null) {
                ((Message)this.body).getExchange().setException((Throwable)e);
            }
        }
        this.recordMetadatas.add(recordMetadata);
        if (this.count.decrementAndGet() == 0) {
            this.workerPool.submit(new Runnable(){

                @Override
                public void run() {
                    LOG.trace("All messages sent, continue routing.");
                    if (KafkaProducerCallBack.this.callback != null) {
                        KafkaProducerCallBack.this.callback.done(false);
                    }
                }
            });
        }
    }
}

