/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.producer.support.ProducerUtil;
import org.apache.camel.util.KeyValueHolder;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public class KeyValueHolderIterator
implements Iterator<KeyValueHolder<Object, ProducerRecord>> {
    private final Iterator<Object> msgList;
    private final Exchange exchange;
    private final KafkaConfiguration kafkaConfiguration;
    private final String msgTopic;
    private final List<Header> propagatedHeaders;

    public KeyValueHolderIterator(Iterator<Object> msgList, Exchange exchange, KafkaConfiguration kafkaConfiguration, String msgTopic, List<Header> propagatedHeaders) {
        this.msgList = msgList;
        this.exchange = exchange;
        this.kafkaConfiguration = kafkaConfiguration;
        this.msgTopic = msgTopic;
        this.propagatedHeaders = propagatedHeaders;
    }

    @Override
    public boolean hasNext() {
        return this.msgList.hasNext();
    }

    @Override
    public KeyValueHolder<Object, ProducerRecord> next() {
        Object next = this.msgList.next();
        String innerTopic = this.msgTopic;
        Object innerKey = null;
        Integer innerPartitionKey = null;
        Long innerTimestamp = null;
        Object value = next;
        Exchange ex = null;
        Object body = next;
        if (next instanceof Exchange || next instanceof Message) {
            Exchange innerExchange = null;
            Message innerMessage = null;
            if (next instanceof Exchange) {
                innerExchange = (Exchange)next;
                innerMessage = innerExchange.getIn();
            } else {
                innerMessage = (Message)next;
            }
            innerTopic = this.getInnerTopic(innerTopic, innerMessage);
            if (innerMessage.getHeader("kafka.PARTITION_KEY") != null) {
                innerPartitionKey = this.getInnerPartitionKey(innerMessage);
            }
            if (innerMessage.getHeader("kafka.KEY") != null) {
                innerKey = this.getInnerKey(innerExchange, innerMessage);
            }
            innerTimestamp = this.getOverrideTimestamp(innerTimestamp, innerMessage);
            ex = innerExchange == null ? this.exchange : innerExchange;
            value = ProducerUtil.tryConvertToSerializedType(ex, innerMessage.getBody(), this.kafkaConfiguration.getValueSerializer());
        }
        return new KeyValueHolder(body, (Object)new ProducerRecord(innerTopic, innerPartitionKey, innerTimestamp, innerKey, value, this.propagatedHeaders));
    }

    private boolean hasValidTimestampHeader(Message innerMessage) {
        if (innerMessage.getHeader("kafka.OVERRIDE_TIMESTAMP") != null) {
            return innerMessage.getHeader("kafka.OVERRIDE_TIMESTAMP") instanceof Long;
        }
        return false;
    }

    private Long getOverrideTimestamp(Long innerTimestamp, Message innerMessage) {
        if (this.hasValidTimestampHeader(innerMessage)) {
            innerTimestamp = (Long)innerMessage.removeHeader("kafka.OVERRIDE_TIMESTAMP");
        }
        return innerTimestamp;
    }

    private String getInnerTopic(String innerTopic, Message innerMessage) {
        if (innerMessage.getHeader("kafka.OVERRIDE_TOPIC") != null) {
            innerTopic = (String)innerMessage.removeHeader("kafka.OVERRIDE_TOPIC");
        }
        return innerTopic;
    }

    private Object getInnerKey(Exchange innerExchange, Message innerMmessage) {
        Object innerKey;
        Object object = innerKey = this.kafkaConfiguration.getKey() != null ? this.kafkaConfiguration.getKey() : innerMmessage.getHeader("kafka.KEY");
        if (innerKey != null) {
            innerKey = ProducerUtil.tryConvertToSerializedType(innerExchange, innerKey, this.kafkaConfiguration.getKeySerializer());
        }
        return innerKey;
    }

    private Integer getInnerPartitionKey(Message innerMessage) {
        return this.kafkaConfiguration.getPartitionKey() != null ? this.kafkaConfiguration.getPartitionKey() : (Integer)innerMessage.getHeader("kafka.PARTITION_KEY", Integer.class);
    }

    @Override
    public void remove() {
        this.msgList.remove();
    }
}

