/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.kafka.DefaultKafkaClientFactory;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.consumer.DefaultKafkaManualCommitFactory;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;

@Component(value="kafka")
public class KafkaComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata
    private KafkaConfiguration configuration = new KafkaConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(autowired=true, label="consumer,advanced")
    private KafkaManualCommitFactory kafkaManualCommitFactory;
    @Metadata(autowired=true, label="advanced")
    private KafkaClientFactory kafkaClientFactory;
    @Metadata(autowired=true, label="consumer,advanced")
    private PollExceptionStrategy pollExceptionStrategy;

    public KafkaComponent() {
    }

    public KafkaComponent(CamelContext context) {
        super(context);
    }

    protected KafkaEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining)) {
            throw new IllegalArgumentException("Topic must be configured on endpoint using syntax kafka:topic");
        }
        Map endpointAdditionalProperties = PropertiesHelper.extractProperties(parameters, (String)"additionalProperties.");
        KafkaEndpoint endpoint = new KafkaEndpoint(uri, this);
        KafkaConfiguration copy = this.getConfiguration().copy();
        endpoint.setConfiguration(copy);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().getSslContextParameters() == null) {
            endpoint.getConfiguration().setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        if (!endpointAdditionalProperties.isEmpty()) {
            endpoint.getConfiguration().getAdditionalProperties().putAll(endpointAdditionalProperties);
        }
        if (endpoint.getConfiguration().getTopic() == null) {
            endpoint.getConfiguration().setTopic(remaining);
        }
        return endpoint;
    }

    public KafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public KafkaManualCommitFactory getKafkaManualCommitFactory() {
        return this.kafkaManualCommitFactory;
    }

    public void setKafkaManualCommitFactory(KafkaManualCommitFactory kafkaManualCommitFactory) {
        this.kafkaManualCommitFactory = kafkaManualCommitFactory;
    }

    public KafkaClientFactory getKafkaClientFactory() {
        return this.kafkaClientFactory;
    }

    public void setKafkaClientFactory(KafkaClientFactory kafkaClientFactory) {
        this.kafkaClientFactory = kafkaClientFactory;
    }

    public PollExceptionStrategy getPollExceptionStrategy() {
        return this.pollExceptionStrategy;
    }

    public void setPollExceptionStrategy(PollExceptionStrategy pollExceptionStrategy) {
        this.pollExceptionStrategy = pollExceptionStrategy;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.kafkaClientFactory == null) {
            this.kafkaClientFactory = new DefaultKafkaClientFactory();
        }
        if (this.kafkaManualCommitFactory == null) {
            this.kafkaManualCommitFactory = new DefaultKafkaManualCommitFactory();
        }
    }
}

