/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import java.time.Duration;
import java.util.Collections;
import org.apache.camel.component.kafka.consumer.DefaultKafkaManualCommit;
import org.apache.camel.component.kafka.consumer.KafkaManualCommit;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaManualSyncCommit
extends DefaultKafkaManualCommit
implements KafkaManualCommit {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaManualSyncCommit.class);

    public DefaultKafkaManualSyncCommit(KafkaManualCommitFactory.CamelExchangePayload camelExchangePayload, KafkaManualCommitFactory.KafkaRecordPayload kafkaRecordPayload) {
        super(camelExchangePayload, kafkaRecordPayload);
    }

    @Override
    public void commit() {
        this.commitOffset(this.getOffsetRepository(), this.getPartition(), this.getRecordOffset());
    }

    protected void commitOffset(StateRepository<String, String> offsetRepository, TopicPartition partition, long recordOffset) {
        if (recordOffset != -1L) {
            if (offsetRepository != null) {
                offsetRepository.setState((Object)this.serializeOffsetKey(partition), (Object)this.serializeOffsetValue(recordOffset));
            } else {
                LOG.debug("CommitSync {} from topic {} with offset: {}", new Object[]{this.getThreadId(), this.getTopicName(), recordOffset});
                this.camelExchangePayload.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(recordOffset + 1L)), Duration.ofMillis(this.getCommitTimeout()));
                LOG.debug("CommitSync done for {} from topic {} with offset: {}", new Object[]{this.getThreadId(), this.getTopicName(), recordOffset});
            }
        }
    }
}

