/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import java.time.Duration;
import java.util.Collections;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncCommitManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(SyncCommitManager.class);
    private final Consumer<?, ?> consumer;

    public SyncCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
        this.consumer = consumer;
    }

    @Override
    public void commit() {
        LOG.info("Auto commitSync {} from {}", (Object)this.threadId, (Object)this.printableTopic);
        this.consumer.commitSync();
    }

    @Override
    public void commitOffsetOnStop(TopicPartition partition, long partitionLastOffset) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auto commitSync on stop {} from topic {}", (Object)this.threadId, (Object)partition.topic());
        }
        this.commitSync(partition, partitionLastOffset);
    }

    @Override
    public void commitOffset(TopicPartition partition, long partitionLastOffset) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auto commitSync from thread {} from topic {}", (Object)this.threadId, (Object)partition.topic());
        }
        this.commitSync(partition, partitionLastOffset);
    }

    private void commitSync(TopicPartition partition, long partitionLastOffset) {
        long timeout = this.configuration.getCommitTimeoutMs();
        this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)), Duration.ofMillis(timeout));
    }
}

