/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ResumeAware;
import org.apache.camel.component.kafka.DefaultPollExceptionStrategy;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumerHealthCheck;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.KafkaFetchRecords;
import org.apache.camel.component.kafka.KafkaHealthCheckRepository;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckAware;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer
extends DefaultConsumer
implements ResumeAware<KafkaConsumerResumeStrategy>,
HealthCheckAware {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsumer.class);
    protected ExecutorService executor;
    private final KafkaEndpoint endpoint;
    private KafkaConsumerHealthCheck consumerHealthCheck;
    private KafkaHealthCheckRepository healthCheckRepository;
    private final List<KafkaFetchRecords> tasks = new ArrayList<KafkaFetchRecords>();
    private volatile boolean stopOffsetRepo;
    private PollExceptionStrategy pollExceptionStrategy;
    private KafkaConsumerResumeStrategy resumeStrategy;

    public KafkaConsumer(KafkaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void setResumeStrategy(KafkaConsumerResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public KafkaConsumerResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.pollExceptionStrategy = this.endpoint.getComponent().getPollExceptionStrategy() != null ? this.endpoint.getComponent().getPollExceptionStrategy() : new DefaultPollExceptionStrategy(this.endpoint.getConfiguration().getPollOnError());
    }

    public KafkaEndpoint getEndpoint() {
        return (KafkaEndpoint)super.getEndpoint();
    }

    private String randomUUID() {
        return UUID.randomUUID().toString();
    }

    Properties getProps() {
        KafkaConfiguration configuration = this.endpoint.getConfiguration();
        Properties props = configuration.createConsumerProperties();
        this.endpoint.updateClassProperties(props);
        ObjectHelper.ifNotEmpty((Object)this.endpoint.getKafkaClientFactory().getBrokers(configuration), v -> props.put("bootstrap.servers", v));
        String groupId = (String)ObjectHelper.supplyIfEmpty((Object)configuration.getGroupId(), this::randomUUID);
        props.put("group.id", groupId);
        ObjectHelper.ifNotEmpty((Object)configuration.getGroupInstanceId(), v -> props.put("group.instance.id", v));
        return props;
    }

    List<KafkaFetchRecords> getTasks() {
        return this.tasks;
    }

    protected void doStart() throws Exception {
        boolean started;
        StateRepository<String, String> repo;
        LOG.info("Starting Kafka consumer on topic: {} with breakOnFirstError: {}", (Object)this.endpoint.getConfiguration().getTopic(), (Object)this.endpoint.getConfiguration().isBreakOnFirstError());
        super.doStart();
        this.healthCheckRepository = (KafkaHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.endpoint.getCamelContext(), (String)"camel-kafka", KafkaHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.consumerHealthCheck = new KafkaConsumerHealthCheck(this, this.getRouteId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.consumerHealthCheck);
        }
        if ((repo = this.endpoint.getConfiguration().getOffsetRepository()) instanceof ServiceSupport && !(started = ((ServiceSupport)repo).isStarted())) {
            this.stopOffsetRepo = true;
            LOG.debug("Starting OffsetRepository: {}", repo);
            ServiceHelper.startService(this.endpoint.getConfiguration().getOffsetRepository());
        }
        this.executor = this.endpoint.createExecutor();
        String topic = this.endpoint.getConfiguration().getTopic();
        Pattern pattern = null;
        if (this.endpoint.getConfiguration().isTopicIsPattern()) {
            pattern = Pattern.compile(topic);
        }
        BridgeExceptionHandlerToErrorHandler bridge = new BridgeExceptionHandlerToErrorHandler((DefaultConsumer)this);
        for (int i = 0; i < this.endpoint.getConfiguration().getConsumersCount(); ++i) {
            KafkaFetchRecords task = new KafkaFetchRecords(this, this.pollExceptionStrategy, bridge, topic, pattern, "" + i, this.getProps());
            this.executor.submit(task);
            this.tasks.add(task);
        }
    }

    protected void doStop() throws Exception {
        LOG.info("Stopping Kafka consumer on topic: {}", (Object)this.endpoint.getConfiguration().getTopic());
        if (this.healthCheckRepository != null && this.consumerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.consumerHealthCheck);
            this.consumerHealthCheck = null;
        }
        if (this.executor != null) {
            int timeout;
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                for (KafkaFetchRecords task : this.tasks) {
                    task.stop();
                }
                timeout = this.getEndpoint().getConfiguration().getShutdownTimeout();
                LOG.debug("Shutting down Kafka consumer worker threads with timeout {} millis", (Object)timeout);
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor, (long)timeout);
            } else {
                this.executor.shutdown();
                timeout = this.endpoint.getConfiguration().getShutdownTimeout();
                LOG.debug("Shutting down Kafka consumer worker threads with timeout {} millis", (Object)timeout);
                if (!this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                    LOG.warn("Shutting down Kafka {} consumer worker threads did not finish within {} millis", (Object)this.tasks.size(), (Object)timeout);
                }
            }
            if (!this.executor.isTerminated()) {
                this.tasks.forEach(KafkaFetchRecords::stop);
                this.executor.shutdownNow();
            }
        }
        this.tasks.clear();
        this.executor = null;
        if (this.stopOffsetRepo) {
            StateRepository<String, String> repo = this.endpoint.getConfiguration().getOffsetRepository();
            LOG.debug("Stopping OffsetRepository: {}", repo);
            ServiceHelper.stopAndShutdownService(repo);
        }
        super.doStop();
    }
}

