/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.KafkaFetchRecords;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.TimeUtils;

public class KafkaConsumerHealthCheck
extends AbstractHealthCheck {
    private final KafkaConsumer kafkaConsumer;
    private final String routeId;

    public KafkaConsumerHealthCheck(KafkaConsumer kafkaConsumer, String routeId) {
        super("camel", "kafka-consumer-" + routeId);
        this.kafkaConsumer = kafkaConsumer;
        this.routeId = routeId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        List<KafkaFetchRecords> tasks = this.kafkaConsumer.getTasks();
        for (KafkaFetchRecords task : tasks) {
            if (task.isReady()) continue;
            builder.down();
            Object msg = "KafkaConsumer is not ready";
            if (task.isTerminated()) {
                msg = (String)msg + " (gave up recovering and terminated the kafka consumer; restart route or application to recover).";
            } else if (task.isRecoverable()) {
                String time = TimeUtils.printDuration((long)task.getCurrentRecoveryInterval());
                msg = (String)msg + " (recovery in progress using " + time + " intervals).";
            }
            builder.message((String)msg);
            builder.error((Throwable)task.getLastError());
            KafkaConfiguration cfg = this.kafkaConsumer.getEndpoint().getConfiguration();
            Properties props = task.getKafkaProps();
            builder.detail("bootstrap.servers", (Object)props.getProperty("bootstrap.servers"));
            builder.detail("client.id", (Object)task.getClientId());
            String gid = props.getProperty("group.id");
            if (gid != null) {
                builder.detail("group.id", (Object)gid);
            }
            if (this.routeId != null) {
                builder.detail("route.id", (Object)this.routeId);
            }
            builder.detail("topic", (Object)cfg.getTopic());
            return;
        }
    }
}

