/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessor;
import org.apache.camel.component.kafka.consumer.support.KafkaResumable;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignmentListener
implements ConsumerRebalanceListener {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionAssignmentListener.class);
    private final String threadId;
    private final KafkaConfiguration configuration;
    private final Map<String, Long> lastProcessedOffset;
    private final KafkaConsumerResumeStrategy resumeStrategy;
    private final CommitManager commitManager;
    private final Supplier<Boolean> stopStateSupplier;

    public PartitionAssignmentListener(String threadId, KafkaConfiguration configuration, Map<String, Long> lastProcessedOffset, Supplier<Boolean> stopStateSupplier, CommitManager commitManager, KafkaConsumerResumeStrategy resumeStrategy) {
        this.threadId = threadId;
        this.configuration = configuration;
        this.lastProcessedOffset = lastProcessedOffset;
        this.commitManager = commitManager;
        this.stopStateSupplier = stopStateSupplier;
        this.resumeStrategy = resumeStrategy;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        boolean stopping = this.stopStateSupplier.get();
        for (TopicPartition partition : partitions) {
            LOG.debug("onPartitionsRevoked: {} from {}", (Object)this.threadId, (Object)partition.topic());
            String offsetKey = KafkaRecordProcessor.serializeOffsetKey(partition);
            Long offset = this.lastProcessedOffset.get(offsetKey);
            if (offset == null) {
                offset = -1L;
            }
            try {
                if (this.configuration.getAutoCommitEnable() || offset == -1L) continue;
                if (stopping) {
                    this.commitManager.commitOffsetOnStop(partition, offset);
                    continue;
                }
                this.commitManager.commitOffset(partition, offset);
            }
            catch (Exception e) {
                LOG.error("Error saving offset repository state {} from offsetKey {} with offset: {}", new Object[]{this.threadId, offsetKey, offset});
                throw e;
            }
            finally {
                this.lastProcessedOffset.remove(offsetKey);
            }
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        if (LOG.isDebugEnabled()) {
            partitions.forEach(p -> LOG.debug("onPartitionsAssigned: {} from {}", (Object)this.threadId, (Object)p.topic()));
        }
        List<KafkaResumable> resumables = partitions.stream().map(p -> new KafkaResumable(String.valueOf(p.partition()), p.topic())).collect(Collectors.toList());
        resumables.forEach(r -> this.resumeStrategy.resume((KafkaResumable)r));
    }
}

