/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy;
import org.apache.camel.component.kafka.consumer.support.OffsetKafkaConsumerResumeStrategy;
import org.apache.camel.component.kafka.consumer.support.SeekPolicyKafkaConsumerResumeStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResumeStrategyFactory {
    private static final NoOpKafkaConsumerResumeStrategy NO_OP_RESUME_STRATEGY = new NoOpKafkaConsumerResumeStrategy();
    private static final Logger LOG = LoggerFactory.getLogger(ResumeStrategyFactory.class);

    private ResumeStrategyFactory() {
    }

    public static KafkaConsumerResumeStrategy newResumeStrategy(KafkaConsumer kafkaConsumer) {
        KafkaConsumerResumeStrategy resumableRouteStrategy = kafkaConsumer.getResumeStrategy();
        if (resumableRouteStrategy != null) {
            return resumableRouteStrategy;
        }
        KafkaConfiguration configuration = kafkaConsumer.getEndpoint().getConfiguration();
        return ResumeStrategyFactory.builtinResumeStrategies(configuration);
    }

    private static KafkaConsumerResumeStrategy builtinResumeStrategies(KafkaConfiguration configuration) {
        LOG.debug("No resume strategy was provided ... checking for built-ins ...");
        StateRepository<String, String> offsetRepository = configuration.getOffsetRepository();
        String seekTo = configuration.getSeekTo();
        if (offsetRepository != null) {
            LOG.info("Using resume from offset strategy");
            return new OffsetKafkaConsumerResumeStrategy(offsetRepository);
        }
        if (seekTo != null) {
            LOG.info("Using resume from seek policy strategy with seeking from {}", (Object)seekTo);
            return new SeekPolicyKafkaConsumerResumeStrategy(seekTo);
        }
        LOG.info("Using NO-OP resume strategy");
        return NO_OP_RESUME_STRATEGY;
    }

    private static class NoOpKafkaConsumerResumeStrategy
    implements KafkaConsumerResumeStrategy {
        private NoOpKafkaConsumerResumeStrategy() {
        }

        @Override
        public void setConsumer(Consumer<?, ?> consumer) {
        }

        public void resume() {
        }
    }
}

