/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.camel.component.kafka.consumer.DefaultKafkaManualAsyncCommitFactory;
import org.apache.camel.component.kafka.consumer.KafkaManualCommit;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.consumer.OffsetCache;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCommitManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncCommitManager.class);
    private final Consumer<?, ?> consumer;
    private final OffsetCache offsetCache = new OffsetCache();

    public AsyncCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
        this.consumer = consumer;
    }

    @Override
    public void commit() {
        if (this.kafkaConsumer.getEndpoint().getConfiguration().isAutoCommitEnable()) {
            LOG.info("Auto commitAsync {} from {}", (Object)this.threadId, (Object)this.printableTopic);
            this.consumer.commitAsync();
        }
    }

    @Override
    public void commit(TopicPartition partition) {
        Long offset = this.offsetCache.getOffset(partition);
        if (offset == null) {
            return;
        }
        this.commitAsync(this.consumer, partition, offset);
    }

    private void commitAsync(Consumer<?, ?> consumer, TopicPartition partition, long partitionLastOffset) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auto commitAsync on stop {} from topic {}", (Object)this.threadId, (Object)partition.topic());
        }
        Map<TopicPartition, OffsetAndMetadata> topicPartitionOffsetAndMetadataMap = Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L));
        consumer.commitAsync(topicPartitionOffsetAndMetadataMap, this.offsetCache::removeCommittedEntries);
    }

    @Override
    public KafkaManualCommit getManualCommit(Exchange exchange, TopicPartition partition, ConsumerRecord<Object, Object> record) {
        KafkaManualCommitFactory manualCommitFactory = this.kafkaConsumer.getEndpoint().getKafkaManualCommitFactory();
        if (manualCommitFactory == null) {
            manualCommitFactory = new DefaultKafkaManualAsyncCommitFactory();
        }
        return this.getManualCommit(exchange, partition, record, manualCommitFactory);
    }

    @Override
    public void recordOffset(TopicPartition partition, long partitionLastOffset) {
        this.offsetCache.recordOffset(partition, partitionLastOffset);
    }
}

