/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume.kafka;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategy;
import org.apache.camel.processor.resume.kafka.RecordError;
import org.apache.camel.resume.Resumable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleNodeKafkaResumeStrategy<K, V>
implements KafkaResumeStrategy<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleNodeKafkaResumeStrategy.class);
    private final String topic;
    private Consumer<K, V> consumer;
    private Producer<K, V> producer;
    private Duration pollDuration = Duration.ofSeconds(1L);
    private final Queue<RecordError> producerErrors = new ConcurrentLinkedQueue<RecordError>();
    private final ResumeCache<K, V> resumeCache;
    private boolean subscribed;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private ResumeAdapter resumeAdapter;

    public SingleNodeKafkaResumeStrategy(String bootstrapServers, String topic, ResumeCache<K, V> resumeCache, ResumeAdapter resumeAdapter) {
        this(topic, resumeCache, resumeAdapter, SingleNodeKafkaResumeStrategy.createProducer(bootstrapServers), SingleNodeKafkaResumeStrategy.createConsumer(bootstrapServers));
    }

    public SingleNodeKafkaResumeStrategy(String topic, ResumeCache<K, V> resumeCache, ResumeAdapter resumeAdapter, Properties producerConfig, Properties consumerConfig) {
        this.topic = (String)ObjectHelper.notNull((Object)topic, (String)"The topic must not be null");
        this.resumeCache = resumeCache;
        this.resumeAdapter = resumeAdapter;
        this.producerConfig = producerConfig;
        this.consumerConfig = consumerConfig;
        this.init();
    }

    public static Properties createProducer(String bootstrapServers) {
        Properties config = new Properties();
        config.put("key.serializer", StringSerializer.class.getName());
        config.put("value.serializer", StringSerializer.class.getName());
        StringHelper.notEmpty((String)bootstrapServers, (String)"bootstrapServers");
        config.put("bootstrap.servers", bootstrapServers);
        return config;
    }

    public static Properties createConsumer(String bootstrapServers) {
        Properties config = new Properties();
        config.put("key.deserializer", StringDeserializer.class.getName());
        config.put("value.deserializer", StringDeserializer.class.getName());
        StringHelper.notEmpty((String)bootstrapServers, (String)"bootstrapServers");
        config.put("bootstrap.servers", bootstrapServers);
        String groupId = UUID.randomUUID().toString();
        LOG.debug("Creating consumer with {}[{}]", (Object)"group.id", (Object)groupId);
        config.put("group.id", groupId);
        config.put("enable.auto.commit", Boolean.TRUE.toString());
        return config;
    }

    protected void produce(K key, V message) throws ExecutionException, InterruptedException {
        ProducerRecord record = new ProducerRecord(this.topic, key, message);
        this.producer.send(record, (recordMetadata, e) -> {
            if (e != null) {
                LOG.error("Failed to send message {}", (Object)e.getMessage(), (Object)e);
                this.producerErrors.add(new RecordError(recordMetadata, e));
            }
        });
    }

    public void updateLastOffset(Resumable<K, V> offset) throws Exception {
        Object key = offset.getAddressable();
        Object offsetValue = offset.getLastOffset().offset();
        LOG.debug("Updating offset on Kafka with key {} to {}", key, offsetValue);
        this.produce(key, offsetValue);
        this.resumeCache.add(key, offsetValue);
    }

    protected void loadCache() throws Exception {
        ConsumerRecords<K, V> records;
        this.subscribe();
        LOG.debug("Loading records from topic {}", (Object)this.topic);
        block0: while (!(records = this.consume()).isEmpty()) {
            for (ConsumerRecord record : records) {
                Object value = record.value();
                LOG.trace("Read from Kafka: {}", value);
                this.resumeCache.add(record.key(), record.value());
                if (!this.resumeCache.isFull()) continue;
                continue block0;
            }
        }
        this.unsubscribe();
    }

    protected void checkAndSubscribe(String topic) {
        if (!this.subscribed) {
            this.consumer.subscribe(Collections.singletonList(topic));
            this.subscribed = true;
        }
    }

    public void checkAndSubscribe(String topic, long remaining) {
        if (!this.subscribed) {
            this.consumer.subscribe(Collections.singletonList(topic), this.getConsumerRebalanceListener(remaining));
            this.subscribed = true;
        }
    }

    protected ConsumerRebalanceListener getConsumerRebalanceListener(final long remaining) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> assignments) {
                for (TopicPartition assignment : assignments) {
                    long endPosition = SingleNodeKafkaResumeStrategy.this.consumer.position(assignment);
                    long startPosition = endPosition - remaining;
                    if (startPosition >= 0L) {
                        SingleNodeKafkaResumeStrategy.this.consumer.seek(assignment, startPosition);
                        continue;
                    }
                    LOG.info("Ignoring the seek command because the initial offset is negative (the topic is likely empty)");
                }
            }
        };
    }

    protected void unsubscribe() {
        try {
            this.consumer.unsubscribe();
        }
        catch (IllegalStateException e) {
            LOG.warn("The consumer is likely already closed. Skipping unsubscribing from {}", (Object)this.topic);
        }
        catch (Exception e) {
            LOG.error("Error unsubscribing from the Kafka topic {}: {}", new Object[]{this.topic, e.getMessage(), e});
        }
    }

    protected ConsumerRecords<K, V> consume() {
        int retries = 10;
        return this.consume(retries);
    }

    protected ConsumerRecords<K, V> consume(int retries) {
        while (retries > 0) {
            ConsumerRecords records = this.consumer.poll(this.pollDuration);
            if (!records.isEmpty()) {
                return records;
            }
            --retries;
        }
        return ConsumerRecords.empty();
    }

    public void subscribe() throws Exception {
        if (this.resumeCache.capacity() >= 1L) {
            this.checkAndSubscribe(this.topic, this.resumeCache.capacity());
        } else {
            this.checkAndSubscribe(this.topic);
        }
    }

    public ResumeAdapter getAdapter() {
        return this.resumeAdapter;
    }

    protected Collection<RecordError> getProducerErrors() {
        return Collections.unmodifiableCollection(this.producerErrors);
    }

    public void build() {
    }

    public void init() {
        LOG.debug("Initializing the Kafka resume strategy");
        if (this.consumer == null) {
            this.consumer = new KafkaConsumer(this.consumerConfig);
        }
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.producerConfig);
        }
    }

    public void stop() {
        LOG.info("Closing the Kafka producer");
        IOHelper.close(this.producer, (String)"Kafka producer", (Logger)LOG);
        LOG.info("Closing the Kafka consumer");
        IOHelper.close(this.producer, (String)"Kafka consumer", (Logger)LOG);
    }

    public void close() throws IOException {
        this.stop();
    }

    public void start() {
        LOG.info("Starting the kafka resume strategy");
        try {
            this.loadCache();
        }
        catch (Exception e) {
            LOG.error("Failed to load already processed items: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public void setPollDuration(Duration pollDuration) {
        this.pollDuration = Objects.requireNonNull(pollDuration, "The poll duration cannot be null");
    }

    protected Consumer<K, V> getConsumer() {
        return this.consumer;
    }

    protected Producer<K, V> getProducer() {
        return this.producer;
    }

    protected Properties getProducerConfig() {
        return this.producerConfig;
    }

    protected Properties getConsumerConfig() {
        return this.consumerConfig;
    }

    protected String getTopic() {
        return this.topic;
    }

    protected ResumeCache<K, V> getResumeCache() {
        return this.resumeCache;
    }

    public void resetProducerErrors() {
        this.producerErrors.clear();
    }
}

