/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.errorhandler.KafkaConsumerListener;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessor;
import org.apache.camel.component.kafka.consumer.support.ProcessingResult;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRecordProcessorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaRecordProcessorFacade.class);
    private final KafkaConsumer camelKafkaConsumer;
    private final String threadId;
    private final KafkaRecordProcessor kafkaRecordProcessor;
    private final CommitManager commitManager;
    private final KafkaConsumerListener consumerListener;

    public KafkaRecordProcessorFacade(KafkaConsumer camelKafkaConsumer, String threadId, CommitManager commitManager, KafkaConsumerListener consumerListener) {
        this.camelKafkaConsumer = camelKafkaConsumer;
        this.threadId = threadId;
        this.commitManager = commitManager;
        this.kafkaRecordProcessor = this.buildKafkaRecordProcessor(commitManager);
        this.consumerListener = consumerListener;
    }

    private boolean isStopping() {
        return this.camelKafkaConsumer.isStopping();
    }

    public ProcessingResult processPolledRecords(ConsumerRecords<Object, Object> allRecords, ProcessingResult resultFromPreviousPoll) {
        ProcessingResult lastResult;
        this.logRecords(allRecords);
        Set partitions = allRecords.partitions();
        Iterator partitionIterator = partitions.iterator();
        LOG.debug("Poll received records on {} partitions", (Object)partitions.size());
        ProcessingResult processingResult = lastResult = resultFromPreviousPoll == null ? ProcessingResult.newUnprocessed() : resultFromPreviousPoll;
        while (partitionIterator.hasNext() && !this.isStopping()) {
            TopicPartition partition = (TopicPartition)partitionIterator.next();
            LOG.debug("Processing records on partition {}", (Object)partition.partition());
            List partitionRecords = allRecords.records(partition);
            Iterator recordIterator = partitionRecords.iterator();
            this.logRecordsInPartition(partitionRecords, partition);
            while (!lastResult.isBreakOnErrorHit() && recordIterator.hasNext() && !this.isStopping()) {
                ConsumerRecord consumerRecord = (ConsumerRecord)recordIterator.next();
                LOG.debug("Processing record on partition {} with offset {}", (Object)consumerRecord.partition(), (Object)consumerRecord.offset());
                lastResult = this.processRecord(partition, partitionIterator.hasNext(), recordIterator.hasNext(), lastResult, this.kafkaRecordProcessor, (ConsumerRecord<Object, Object>)consumerRecord);
                LOG.debug("Processed record on partition {} with offset {} and got ProcessingResult for partition {} and offset {}", new Object[]{consumerRecord.partition(), consumerRecord.offset(), lastResult.getPartition(), lastResult.getPartitionLastOffset()});
                if (this.consumerListener == null || this.consumerListener.afterProcess(lastResult)) continue;
                this.commitManager.commit(partition);
                return lastResult;
            }
            if (lastResult.isBreakOnErrorHit()) continue;
            LOG.debug("Committing offset on successful execution");
            this.commitManager.commit(partition);
        }
        return lastResult;
    }

    private void logRecordsInPartition(List<ConsumerRecord<Object, Object>> partitionRecords, TopicPartition partition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Records count {} received for partition {}", (Object)partitionRecords.size(), (Object)partition);
        }
    }

    private void logRecords(ConsumerRecords<Object, Object> allRecords) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Last poll on thread {} resulted on {} records to process", (Object)this.threadId, (Object)allRecords.count());
        }
    }

    private ProcessingResult processRecord(TopicPartition partition, boolean partitionHasNext, boolean recordHasNext, ProcessingResult lastResult, KafkaRecordProcessor kafkaRecordProcessor, ConsumerRecord<Object, Object> consumerRecord) {
        this.logRecord(consumerRecord);
        Exchange exchange = this.camelKafkaConsumer.createExchange(false);
        ProcessingResult currentResult = kafkaRecordProcessor.processExchange(exchange, partition, partitionHasNext, recordHasNext, consumerRecord, lastResult, this.camelKafkaConsumer.getExceptionHandler());
        if (!currentResult.isBreakOnErrorHit()) {
            this.commitManager.recordOffset(partition, currentResult.getPartitionLastOffset());
        }
        this.camelKafkaConsumer.releaseExchange(exchange, false);
        return currentResult;
    }

    private void logRecord(ConsumerRecord<Object, Object> consumerRecord) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Partition = {}, offset = {}, key = {}, value = {}", new Object[]{consumerRecord.partition(), consumerRecord.offset(), consumerRecord.key(), consumerRecord.value()});
        }
    }

    private KafkaRecordProcessor buildKafkaRecordProcessor(CommitManager commitManager) {
        return new KafkaRecordProcessor(this.camelKafkaConsumer.getEndpoint().getConfiguration(), this.camelKafkaConsumer.getProcessor(), commitManager);
    }
}

